/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ProfileExtensionProvider;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ConnectAction
implements IObjectActionDelegate,
ISelectionProvider {
    private IStructuredSelection mSelection = null;
    private Shell mShell;

    public static void connectAndRefresh(IConnectionProfile profile, TreeViewer viewer) {
        profile.connect();
        viewer.refresh((Object)profile);
        viewer.setExpandedState((Object)profile, true);
    }

    public static Job connect(IConnectionProfile profile, ITreeContentProvider contentProvider) {
        ConnectionProfile.ConnectJob connectJob = new ConnectionProfile.ConnectJob((ConnectionProfile)profile);
        connectJob.schedule();
        return connectJob;
    }

    public ConnectAction() {
    }

    public ConnectAction(Shell shell) {
        this();
        this.mShell = shell;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.mShell = targetPart.getSite().getShell();
    }

    public void run(IAction action) {
        if (this.mSelection != null && this.allProfilesInSelectionAreDisconnected(this.mSelection)) {
            List list = this.mSelection.toList();
            if (list == null || list.size() == 0) {
                return;
            }
            for (int i = 0; i < list.size(); ++i) {
                PropertyDialogAction propertyDialogAction = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)this.mShell), (ISelectionProvider)this);
                if (!(list.get(i) instanceof IConnectionProfile)) continue;
                IConnectionProfile profile = (IConnectionProfile)list.get(i);
                StructuredSelection ssel = new StructuredSelection((Object)profile);
                propertyDialogAction.selectionChanged((IStructuredSelection)ssel);
                if (!profile.arePropertiesComplete() && propertyDialogAction.isApplicableForSelection()) {
                    PreferenceDialog dialog = propertyDialogAction.createDialog();
                    String initialPage = this.getInitialPropertyPageID(profile);
                    if (initialPage != null) {
                        ((IWorkbenchPreferenceContainer)dialog).openPage(initialPage, null);
                    }
                    if (dialog.open() == 1) {
                        return;
                    }
                }
                profile.connect(null);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        this.mSelection = sel = (IStructuredSelection)selection;
        boolean flag = this.checkSelectionForProfiles(this.mSelection);
        boolean allAreDisconnected = false;
        if (flag) {
            allAreDisconnected = this.allProfilesInSelectionAreDisconnected(this.mSelection);
        }
        action.setEnabled(flag && allAreDisconnected);
    }

    private boolean checkSelectionForProfiles(IStructuredSelection selection) {
        List list = selection.toList();
        if (list == null || list.size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof IConnectionProfile) continue;
            return false;
        }
        return true;
    }

    private boolean allProfilesInSelectionAreDisconnected(IStructuredSelection selection) {
        List list = selection.toList();
        if (list == null || list.size() == 0) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            IConnectionProfile profile;
            if (!(list.get(i) instanceof IConnectionProfile) || !(profile = (IConnectionProfile)list.get(i)).isConnected()) continue;
            return false;
        }
        return true;
    }

    public ISelection getSelection() {
        return this.mSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    protected String getInitialPropertyPageID(IConnectionProfile profile) {
        if (!profile.arePropertiesComplete(profile.getProviderId())) {
            return ((ConnectionProfileProvider)profile.getProvider()).getPropertiesPersistenceHook().getConnectionPropertiesPageID();
        }
        Iterator it = profile.getProfileExtensions().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String extID = (String)entry.getKey();
            if (profile.arePropertiesComplete(extID)) continue;
            return ((ProfileExtensionProvider)entry.getValue()).getPropertiesPersistenceHook().getConnectionPropertiesPageID();
        }
        return null;
    }
}

