/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.dialogs.PropertyDialog;
import org.eclipse.ui.internal.dialogs.PropertyPageContributorManager;
import org.eclipse.ui.internal.dialogs.PropertyPageManager;

public class ViewPropertyAction
extends Action {
    public static final String MEMENTO_ROOT = "Connectivity_Property_Dialog_Root";
    public static final String MEMENTO_DIALOG_SIZE_HEIGHT = "Dialog_Size_Height";
    public static final String MEMENTO_DIALOG_SIZE_WIDTH = "Dialog_Size_Width";
    private int mShellWidth = 0;
    private int mShellHeight = 0;
    private TreeViewer mViewer;
    private Shell mShell;

    public ViewPropertyAction(Viewer viewer) {
        this.mViewer = (TreeViewer)viewer;
        this.setText(ConnectivityUIPlugin.getDefault().getResourceString("ServersView.action.showproperties"));
    }

    public static boolean hasContributors(Object selected) {
        if (selected == null || !(selected instanceof IAdaptable)) {
            return false;
        }
        return PropertyPageContributorManager.getManager().hasContributorsFor(selected);
    }

    public void run() {
        IDialogSettings dSection;
        Object selected = this.getSelectedObject();
        if (selected == null || !(selected instanceof IAdaptable)) {
            return;
        }
        IAdaptable adaptable = (IAdaptable)selected;
        PropertyPageManager pageManager = new PropertyPageManager();
        String title = ConnectivityUIPlugin.getDefault().getResourceString("properties.dialog");
        PropertyPageContributorManager.getManager().contribute(pageManager, (Object)adaptable);
        PropertyDialog propertyDialog = new PropertyDialog(this.mViewer.getControl().getShell(), (PreferenceManager)pageManager, this.mViewer.getSelection());
        propertyDialog.create();
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        boolean foundSettings = false;
        if (dset != null && (dSection = dset.getSection(MEMENTO_ROOT)) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT) != null && dSection.get(MEMENTO_DIALOG_SIZE_HEIGHT).trim().length() > 0) {
            this.mShellHeight = dSection.getInt(MEMENTO_DIALOG_SIZE_HEIGHT);
            this.mShellWidth = dSection.getInt(MEMENTO_DIALOG_SIZE_WIDTH);
            foundSettings = true;
        }
        if (foundSettings) {
            propertyDialog.getShell().setSize(this.mShellWidth, this.mShellHeight);
            propertyDialog.getShell().layout();
        }
        this.mShell = propertyDialog.getShell();
        propertyDialog.getShell().setText(title);
        this.mShell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (e.getSource() instanceof Shell) {
                    Shell shell = (Shell)e.getSource();
                    ViewPropertyAction.this.mShellHeight = shell.getSize().y;
                    ViewPropertyAction.this.mShellWidth = shell.getSize().x;
                }
            }
        });
        int rtn_val = propertyDialog.open();
        if (rtn_val == 0) {
            this.saveState();
        }
        this.mViewer.setSelection(this.mViewer.getSelection());
    }

    public Object getSelectedObject() {
        ISelection selection = this.mViewer.getSelection();
        Object selectedObj = null;
        if (selection == null) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selectedObj = structuredSelection.getFirstElement();
        }
        return selectedObj;
    }

    private void saveState() {
        IDialogSettings dset = ConnectivityUIPlugin.getDefault().getDialogSettings();
        if (dset != null && this.mShell != null) {
            IDialogSettings dSection = dset.getSection(MEMENTO_ROOT);
            if (dSection == null) {
                dSection = dset.addNewSection(MEMENTO_ROOT);
            }
            if (dSection != null) {
                dSection.put(MEMENTO_DIALOG_SIZE_HEIGHT, this.mShellHeight);
                dSection.put(MEMENTO_DIALOG_SIZE_WIDTH, this.mShellWidth);
            }
        }
    }
}

