/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.Properties;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.SharedImages;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.internal.ui.refactoring.ConnectionProfileCreateChange;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizard;
import org.eclipse.datatools.connectivity.internal.ui.wizards.SummaryWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.ICPWizard;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizardPage;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public abstract class NewConnectionProfileWizard
extends BaseWizard
implements INewWizard,
ICPWizard {
    protected NewConnectionProfileWizardPage mProfilePage;
    protected SummaryWizardPage mSummaryPage;
    protected String mProviderID;
    protected IConnectionProfile mParentProfile;

    public NewConnectionProfileWizard() {
        this.setWindowTitle(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.title"));
        this.setDefaultPageImageDescriptor(SharedImages.DESC_WIZBAN);
    }

    public boolean performFinish() {
        try {
            this.doFinish();
        }
        catch (CoreException e) {
            ExceptionHandler.showException(this.getShell(), ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizard.create.failure"), e.getLocalizedMessage(), e);
            return false;
        }
        return true;
    }

    private void doFinish() throws CoreException {
        PerformChangeOperation refOperation = new PerformChangeOperation((Change)new ConnectionProfileCreateChange(this.mProfilePage.getProfileName(), this.mProfilePage.getProfileDescription(), this.mProviderID, this.getProfileProperties(), this.getParentProfile(), this.mProfilePage.getAutoConnect(), this.getShell()));
        try {
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)refOperation, null);
        }
        catch (OperationCanceledException oce) {
            throw new OperationCanceledException();
        }
        catch (CoreException ce) {
            throw ce;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void initProviderID(String providerID) {
        this.mProviderID = providerID;
    }

    public abstract void addCustomPages();

    public String getProfileProviderID() {
        return this.mProviderID;
    }

    public String getProfileName() {
        return this.mProfilePage.getProfileName();
    }

    public String getProfileDescription() {
        return this.mProfilePage.getProfileDescription();
    }

    public boolean getProfileIsAutoConnect() {
        return this.mProfilePage.getAutoConnect();
    }

    public abstract Properties getProfileProperties();

    public String getParentProfile() {
        return this.mParentProfile == null ? new String() : this.mParentProfile.getName();
    }

    public void setParentProfile(IConnectionProfile profile) {
        this.mParentProfile = profile;
    }

    public void addPages() {
        super.addPages();
        this.mProfilePage = new NewConnectionProfileWizardPage();
        this.addPage((IWizardPage)this.mProfilePage);
        this.addCustomPages();
        this.mSummaryPage = new SummaryWizardPage(this);
        this.addPage(this.mSummaryPage);
    }
}

