/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.connectivity.internal.ConnectionProfileManager;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.IHelpConstants;
import org.eclipse.datatools.connectivity.internal.ui.wizards.BaseWizardPage;
import org.eclipse.datatools.connectivity.ui.wizards.NewConnectionProfileWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewConnectionProfileWizardPage
extends BaseWizardPage {
    private Text mCPName;
    private Text mCPDesc;
    private Button mAutoConnect;
    private String mCPNameStr;
    private String mCPDescStr;
    private boolean mCPAutoConnectValue = false;
    private boolean _showAutoConnect = true;
    private static final String EMPTY_STRING = "";

    public NewConnectionProfileWizardPage() {
        this("NewConnectionProfileWizardPage");
    }

    public NewConnectionProfileWizardPage(String name) {
        super(name);
        this.setTitle(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.title"));
        this.setDescription(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.desc"));
    }

    public void createControl(Composite parent) {
        String providerID = ((NewConnectionProfileWizard)this.getWizard()).getProfileProviderID();
        IConnectionProfileProvider provider = ConnectionProfileManager.getInstance().getProvider(providerID);
        this._showAutoConnect = provider.needsMaintainConnection();
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        composite.setLayout((Layout)gl);
        new Label(composite, 0).setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_name"));
        this.mCPName = new Text(composite, 2048);
        this.mCPName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConnectionProfileWizardPage.this.handleModify();
            }
        });
        this.mCPName.setLayoutData((Object)new GridData(768));
        new Label(composite, 0).setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.cp_desc"));
        this.mCPDesc = new Text(composite, 2048);
        this.mCPDesc.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.mAutoConnect = new Button(composite, 32);
        this.mAutoConnect.setText(ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Button.AutoConnect"));
        if (!this._showAutoConnect) {
            this.mAutoConnect.setSelection(true);
            this.mAutoConnect.setVisible(false);
            this.mAutoConnect.setEnabled(false);
        }
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 20;
        this.mAutoConnect.setLayoutData((Object)gd);
        if (this.mCPNameStr != null) {
            this.mCPName.setText(this.mCPNameStr);
        }
        if (this.mCPDescStr != null) {
            this.mCPDesc.setText(this.mCPDescStr);
        }
        this.setControl((Control)composite);
        this.setPageComplete(false);
        if (this.mCPName.getText().length() > 0) {
            this.setPageComplete(true);
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, IHelpConstants.CONTEXT_ID_NEW_CONNECTION_PROFILE_PAGE);
    }

    private void handleModify() {
        String errorMessage = null;
        String cpName = this.mCPName.getText();
        if (cpName == null || cpName.trim().length() == 0) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.NoName");
        } else if (ProfileManager.getInstance().getProfileByName(cpName) != null) {
            errorMessage = ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.Status.DuplicateName");
        }
        this.setErrorMessage(errorMessage);
        this.setPageComplete(errorMessage == null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.mCPName.setFocus();
        }
    }

    public String getProfileName() {
        return this.mCPName == null || this.mCPName.isDisposed() ? this.mCPNameStr : this.mCPName.getText();
    }

    public void setProfileName(String name) {
        this.mCPNameStr = name;
        if (this.mCPName != null && !this.mCPName.isDisposed()) {
            if (name == null) {
                name = EMPTY_STRING;
            }
            this.mCPName.setText(name);
        }
    }

    public String getProfileDescription() {
        return this.mCPDesc == null || this.mCPDesc.isDisposed() ? this.mCPDescStr : this.mCPDesc.getText();
    }

    public void setProfileDescription(String desc) {
        this.mCPDescStr = desc;
        if (this.mCPDesc != null && !this.mCPDesc.isDisposed()) {
            if (desc == null) {
                desc = EMPTY_STRING;
            }
            this.mCPDesc.setText(desc);
        }
    }

    public boolean getAutoConnect() {
        return this.mAutoConnect == null || this.mAutoConnect.isDisposed() ? this.mCPAutoConnectValue : this.mAutoConnect.getSelection();
    }

    public void setAutoConnect(boolean selection) {
        this.mCPAutoConnectValue = selection;
        if (this.mAutoConnect != null && !this.mAutoConnect.isDisposed()) {
            this.mAutoConnect.setSelection(selection);
        }
    }

    public List getSummaryData() {
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_cp_name"), this.getProfileName()});
        data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_cp_desc"), this.getProfileDescription()});
        if (this._showAutoConnect) {
            data.add(new String[]{ConnectivityUIPlugin.getDefault().getResourceString("NewConnectionProfileWizardPage.summary_autoconnect"), EMPTY_STRING + this.getAutoConnect()});
        }
        return data;
    }
}

