/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.derby.ddl;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.internal.derby.ddl.DerbyDdlBuilder;
import org.eclipse.datatools.connectivity.internal.derby.ddl.DerbyDdlBuilder101;
import org.eclipse.datatools.connectivity.internal.derby.ddl.DerbyDdlScript;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.core.rte.fe.GenericDdlGenerator;
import org.eclipse.datatools.modelbase.sql.constraints.CheckConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.modelbase.sql.tables.ViewTable;

public final class DerbyDdlGenerator
extends GenericDdlGenerator
implements DDLGenerator,
IExecutableExtension {
    private String product;
    private String version;
    private DerbyDdlBuilder builder = null;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.product = config.getAttribute("product");
        this.version = config.getAttribute("version");
        this.builder = this.version.equals("10.1") ? new DerbyDdlBuilder101() : new DerbyDdlBuilder();
    }

    protected String[] createStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        DerbyDdlScript script = new DerbyDdlScript();
        if (this.builder == null) {
            this.builder = new DerbyDdlBuilder();
        }
        EngineeringOption[] options = this.getSelectedOptions(elements);
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof BaseTable) {
                if (this.generateTables(options) || (statement = this.builder.createTable((BaseTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || (statement = this.builder.createView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateViewStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!this.generateStoredProcedures(options) || (statement = this.builder.createProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!this.generateFunctions(options) || (statement = this.builder.createUserDefinedFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateRoutineStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.createTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addCreateTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || (statement = this.builder.addCheckConstraint((CheckConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generatePKConstraints(options) || (statement = this.builder.addUniqueConstraint((UniqueConstraint)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || (statement = this.builder.addForeignKey((ForeignKey)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableAddForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes(options) || (statement = this.builder.createIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addCreateIndexStatement(statement);
        }
        return script.getStatements();
    }

    protected String[] dropStatements(SQLObject[] elements, boolean quoteIdentifiers, boolean qualifyNames, IProgressMonitor progressMonitor, int task) {
        DerbyDdlScript script = new DerbyDdlScript();
        if (this.builder == null) {
            this.builder = new DerbyDdlBuilder();
        }
        EngineeringOption[] options = this.getSelectedOptions(elements);
        Iterator it = this.getAllContainedDisplayableElementSet(elements).iterator();
        while (it.hasNext()) {
            String statement;
            Object o = it.next();
            if (o instanceof BaseTable) {
                if (!this.generateTables(options) || (statement = this.builder.dropTable((BaseTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTableStatement(statement);
                continue;
            }
            if (o instanceof ViewTable) {
                if (!this.generateViews(options) || (statement = this.builder.dropView((ViewTable)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropViewStatement(statement);
                continue;
            }
            if (o instanceof Procedure) {
                if (!this.generateStoredProcedures(options) || (statement = this.builder.dropProcedure((Procedure)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRoutineStatement(statement);
                continue;
            }
            if (o instanceof UserDefinedFunction) {
                if (!this.generateFunctions(options) || (statement = this.builder.dropFunction((UserDefinedFunction)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropRoutineStatement(statement);
                continue;
            }
            if (o instanceof Trigger) {
                if (!this.generateTriggers(options) || (statement = this.builder.dropTrigger((Trigger)o, quoteIdentifiers, qualifyNames)) == null) continue;
                script.addDropTriggerStatement(statement);
                continue;
            }
            if (o instanceof CheckConstraint) {
                if (!this.generateCKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((CheckConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof UniqueConstraint) {
                if (!this.generatePKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((UniqueConstraint)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropConstraintStatement(statement);
                continue;
            }
            if (o instanceof ForeignKey) {
                if (!this.generateFKConstraints(options) || (statement = this.builder.dropTableConstraint((TableConstraint)((ForeignKey)o), quoteIdentifiers, qualifyNames)) == null) continue;
                script.addAlterTableDropForeignKeyStatement(statement);
                continue;
            }
            if (!(o instanceof Index) || !this.generateIndexes(options) || (statement = this.builder.dropIndex((Index)o, quoteIdentifiers, qualifyNames)) == null) continue;
            script.addDropIndexStatement(statement);
        }
        return script.getStatements();
    }
}

