/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.drivers;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.datatools.connectivity.drivers.DriverInstance;
import org.eclipse.datatools.connectivity.drivers.DriverMgmtMessages;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;

public class DriverValidator {
    private TemplateDescriptor mTemplate;
    private IPropertySet mInstance;
    private String mMessage;

    public DriverValidator(TemplateDescriptor template, IPropertySet instance) {
        this.mTemplate = template;
        this.mInstance = instance;
    }

    public DriverValidator(DriverInstance driverInstance) {
        this.mTemplate = driverInstance.getTemplate();
        this.mInstance = driverInstance.getPropertySet();
    }

    public String getMessage() {
        return this.mMessage;
    }

    public boolean isValid() {
        this.mMessage = null;
        boolean flag = true;
        flag = this.validateJarListFiles();
        if (flag) {
            flag = this.validateProperties();
        }
        return flag;
    }

    private boolean validateProperties() {
        boolean flag = true;
        DriverInstance instance = new DriverInstance(this.mInstance);
        IConfigurationElement[] templateProps = this.mTemplate.getProperties();
        for (int i = 0; i < templateProps.length; ++i) {
            String value;
            IConfigurationElement element = templateProps[i];
            String name = element.getAttribute("name");
            String required = element.getAttribute("required");
            boolean propRequired = true;
            if (required != null && required.equals("false")) {
                propRequired = false;
            }
            boolean exists = (value = instance.getNamedProperty(name)) != null;
            boolean notEmpty = false;
            if (exists) {
                boolean bl = notEmpty = value.length() > 0;
            }
            if (!propRequired || exists && notEmpty) continue;
            flag = false;
            this.mMessage = DriverMgmtMessages.format("DriverValidator.msg.missing_required_property", new String[]{name});
            break;
        }
        return flag;
    }

    private boolean validateJarListFiles() {
        boolean flag = true;
        boolean emptyJarListIsOK = this.mTemplate.getEmptyJarListIsOKFlag();
        if (emptyJarListIsOK) {
            return flag;
        }
        Properties baseProps = this.mInstance.getBaseProperties();
        if (baseProps != null && baseProps.getProperty("jarList") != null) {
            String jarList = baseProps.getProperty("jarList");
            if (jarList != null) {
                if (jarList.length() > 0) {
                    String[] jarListArray = this.parseString(jarList);
                    for (int i = 0; i < jarListArray.length; ++i) {
                        String path = jarListArray[i];
                        File testFile = new File(path);
                        if (testFile.exists()) continue;
                        flag = false;
                        this.mMessage = DriverMgmtMessages.format("DriverValidator.msg.jarfile_not_found", new String[]{path});
                        break;
                    }
                } else {
                    this.mMessage = DriverMgmtMessages.getString("DriverValidator.msg.empty_jar_list");
                    flag = false;
                }
            }
        } else {
            this.mMessage = DriverMgmtMessages.getString("DriverValidator.msg.empty_jar_list");
            flag = false;
        }
        return flag;
    }

    private String[] parseString(String str_list) {
        StringTokenizer tk = new StringTokenizer(str_list, ",");
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }
}

