/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal;

import com.ibm.icu.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.internal.InternalProfileManager;
import org.osgi.framework.BundleContext;

public class ConnectivityPlugin
extends Plugin {
    public static final int INTERNAL_ERROR = 10001;
    public static final String PLUGIN_ID = "org.eclipse.datatools.connectivity";
    private static ConnectivityPlugin plugin;
    private ResourceBundle resourceBundle;

    public ConnectivityPlugin() {
        plugin = this;
    }

    public static ConnectivityPlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        InternalProfileManager.getInstance().dispose();
        super.stop(context);
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.datatools.connectivity.internal.resources");
            }
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public String getResourceString(String key) {
        try {
            ResourceBundle resBundle = this.getResourceBundle();
            if (resBundle == null) {
                return key;
            }
            return resBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public String getResourceString(String key, Object[] arguments) {
        MessageFormat f = new MessageFormat(this.getResourceString(key));
        return f.format((Object)arguments);
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(String message) {
        this.log(this.createErrorStatus(message));
    }

    public void log(Throwable e) {
        this.log(this.createErrorStatus(e));
    }

    public IStatus createErrorStatus(String message) {
        return new Status(4, this.getBundle().getSymbolicName(), 10001, message, null);
    }

    public IStatus createErrorStatus(Throwable e) {
        String message = e == null || e.getMessage() == null ? this.getResourceString("plugin.internal_error") : e.getMessage();
        return new Status(4, this.getBundle().getSymbolicName(), 10001, message, e);
    }
}

