/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.icons.ImageDescription;
import org.eclipse.datatools.connectivity.sqm.core.rte.DDLGenerator;
import org.eclipse.datatools.connectivity.sqm.core.rte.EngineeringOption;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.util.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FEConfigurationData;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FESelectFileWizardPage;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FESelectObjectsWizardPage;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FESelectOptionsWizardPage;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FESummaryProperty;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.FESummaryWizardPage;
import org.eclipse.datatools.connectivity.sqm.fe.internal.ui.wizards.IGenerateDDL;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.internal.core.util.SaveDDLUtility;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;

public class FEWizard
extends Wizard
implements IGenerateDDL {
    private FESelectOptionsWizardPage selectOptionsPage;
    private FESelectObjectsWizardPage selectObjectsPage;
    private FESelectFileWizardPage selectFilePage;
    private FESummaryWizardPage summaryPage;
    private static String SELECT_OPTIONS_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectOptionsPage";
    private static String SELECT_OBJECTS_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectObjectsPage";
    private static String SELECT_FILE_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SelectFilePage";
    private static String SUMMARY_WIZARD_PAGE_NAME = "com.ibm.datatools.modeler.fe.ui.wizards.SummaryPage";
    private List selection;
    private DDLGenerator feProvider;
    private DatabaseDefinition databaseDefinition;
    String lastProductValueSet = "";
    String lastVersionValueSet = "";
    private StringWriter writer = new StringWriter();
    private String[] ddlScripts = new String[0];
    private boolean hasGenerated = false;
    private static String LINE_RETURN = System.getProperty("line.separator");

    public FEWizard(List selection) {
        this.selection = selection;
        this.setWindowTitle(ResourceLoader.INSTANCE.queryString("FE_WIZARD_TITLEBAR_TEXT"));
        this.setDefaultPageImageDescriptor(ImageDescription.getGenerateDDLWizard());
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        Database database = this.getDatabase((EObject)((SQLObject)this.selection.get(0)));
        this.databaseDefinition = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(database.getVendor(), database.getVersion());
        this.feProvider = this.databaseDefinition.getDDLGenerator();
        FEConfigurationData configurationData = new FEConfigurationData(this.feProvider.getOptions(this.selection.toArray(new SQLObject[this.selection.size()])));
        this.selectOptionsPage = new FESelectOptionsWizardPage(SELECT_OPTIONS_WIZARD_PAGE_NAME, configurationData);
        this.addPage((IWizardPage)this.selectOptionsPage);
        this.selectObjectsPage = new FESelectObjectsWizardPage(SELECT_OBJECTS_WIZARD_PAGE_NAME, configurationData);
        this.addPage((IWizardPage)this.selectObjectsPage);
        this.selectFilePage = new FESelectFileWizardPage(SELECT_FILE_WIZARD_PAGE_NAME, this.selection);
        this.addPage((IWizardPage)this.selectFilePage);
        this.selectFilePage.setTerminator(this.databaseDefinition.getSQLTerminationCharacter());
        this.summaryPage = new FESummaryWizardPage(SUMMARY_WIZARD_PAGE_NAME);
        this.addPage((IWizardPage)this.summaryPage);
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void execute(IProgressMonitor monitor) {
                try {
                    FEWizard.this.performDDLGeneration(monitor);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public StringWriter generateDDL() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    FEWizard.this.writer = new StringWriter();
                    monitor.beginTask("", 5);
                    monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.generatingDDLProgressMessage"));
                    monitor.worked(1);
                    FEWizard.this.hasGenerated = false;
                    FEConfigurationData configurationData = FEWizard.this.selectOptionsPage.getOptions();
                    if (configurationData != null) {
                        try {
                            String fullStatementTermination = "";
                            String statementTerminator = FEWizard.this.selectFilePage.getTerminator();
                            fullStatementTermination = statementTerminator.length() < 2 ? fullStatementTermination + statementTerminator + LINE_RETURN + LINE_RETURN : fullStatementTermination + LINE_RETURN + statementTerminator + LINE_RETURN + LINE_RETURN;
                            FEWizard.access$502(FEWizard.this, FEWizard.this.feProvider.generateDDL(FEWizard.this.selection.toArray(new SQLObject[FEWizard.this.selection.size()]), monitor));
                            FEWizard.this.hasGenerated = true;
                            monitor.worked(3);
                            for (int i = 0; i < FEWizard.this.ddlScripts.length; ++i) {
                                FEWizard.this.writer.write(FEWizard.this.ddlScripts[i] + fullStatementTermination);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void performDDLGeneration(IProgressMonitor monitor) {
        block8: {
            try {
                block7: {
                    try {
                        if (!this.hasGenerated) break block7;
                        monitor.worked(2);
                        monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.savingDDLProgressMessage"));
                        IFile ddlFile = SaveDDLUtility.getInstance().saveDDLFileAsResource(this.writer, this.selectFilePage.getResourcePath());
                        monitor.worked(4);
                        if (!this.selectFilePage.isOpenDDLSelected()) break block7;
                        monitor.setTaskName(ResourceLoader.INSTANCE.queryString("FEWizard.openingDDLProgressMessage"));
                        if (ddlFile == null) break block7;
                        IEditorDescriptor editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(ddlFile.getName());
                        if (editorDescriptor == null) {
                            editorDescriptor = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor("file.txt");
                        }
                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(ddlFile), editorDescriptor.getId());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var5_6 = null;
                        if (!this.hasGenerated) {
                            MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 513);
                            box.setMessage(ResourceLoader.INSTANCE.queryString("FEWizard.ddlGenerationErrorMessage"));
                            box.open();
                        }
                        break block8;
                    }
                }
                Object var5_5 = null;
                if (this.hasGenerated) break block8;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (!this.hasGenerated) {
                    MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 513);
                    box.setMessage(ResourceLoader.INSTANCE.queryString("FEWizard.ddlGenerationErrorMessage"));
                    box.open();
                }
                throw throwable;
            }
            MessageBox box = new MessageBox(Display.getCurrent().getActiveShell(), 513);
            box.setMessage(ResourceLoader.INSTANCE.queryString("FEWizard.ddlGenerationErrorMessage"));
            box.open();
        }
        monitor.worked(5);
    }

    public boolean canFinish() {
        boolean canFinish = false;
        canFinish = this.selectOptionsPage.isPageComplete() && this.selectObjectsPage.isPageComplete() && this.selectFilePage.isPageComplete() && this.summaryPage.isVisible();
        return canFinish;
    }

    public IWizardPage getNextPage(IWizardPage wizardPage) {
        Object nextPage = null;
        nextPage = wizardPage.getName().equals(SELECT_OPTIONS_WIZARD_PAGE_NAME) ? this.selectObjectsPage : (wizardPage.getName().equals(SELECT_OBJECTS_WIZARD_PAGE_NAME) ? this.selectFilePage : (wizardPage.getName().equals(SELECT_FILE_WIZARD_PAGE_NAME) ? this.populateSummaryPage() : (wizardPage.getName().equals(SUMMARY_WIZARD_PAGE_NAME) ? null : super.getNextPage(wizardPage))));
        return nextPage;
    }

    private FESummaryWizardPage populateSummaryPage() {
        int index;
        if (this.summaryPage == null) {
            this.summaryPage = new FESummaryWizardPage(SUMMARY_WIZARD_PAGE_NAME);
            this.addPage((IWizardPage)this.summaryPage);
        }
        EngineeringOption[] options = this.selectOptionsPage.getOptions().getOptions();
        FESummaryProperty[] properties = null;
        Vector<FESummaryProperty> propertiesCollection = new Vector<FESummaryProperty>();
        propertiesCollection.add(new FESummaryProperty(ResourceLoader.INSTANCE.queryString("FEWizard.fileLocationSummaryProperty"), this.selectFilePage.getResourcePath()));
        propertiesCollection.add(new FESummaryProperty(ResourceLoader.INSTANCE.queryString("FEWizard.openDDLForEditingSummaryProperty"), String.valueOf(this.selectFilePage.isOpenDDLSelected())));
        propertiesCollection.add(new FESummaryProperty("", ""));
        for (index = 0; index < options.length; ++index) {
            propertiesCollection.add(new FESummaryProperty(options[index].getOptionDescription(), String.valueOf(options[index].getBoolean())));
        }
        propertiesCollection.add(new FESummaryProperty("", ""));
        options = this.selectObjectsPage.getOptions().getOptions();
        for (index = 0; index < options.length; ++index) {
            propertiesCollection.add(new FESummaryProperty(options[index].getOptionDescription(), String.valueOf(options[index].getBoolean())));
        }
        properties = new FESummaryProperty[propertiesCollection.size()];
        propertiesCollection.toArray(properties);
        this.summaryPage.setProperties(properties);
        return this.summaryPage;
    }

    private Database getDatabase(EObject object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Database) {
            return (Database)object;
        }
        return this.getDatabase(RDBCorePlugin.getDefault().getContainmentService().getContainer(object));
    }

    static /* synthetic */ String[] access$502(FEWizard x0, String[] x1) {
        x0.ddlScripts = x1;
        return x1;
    }
}

