/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.impl;

import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.enablement.oda.xml.i18n.Messages;

public final class DataTypes {
    public static final int INT = 4;
    public static final int DOUBLE = 8;
    public static final int STRING = 12;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BLOB = 2004;
    public static final int BIGDECIMAL = 2;
    private static final String XML_DATA_SOURCE_ID = "org.eclipse.datatools.enablement.oda.xml";

    public static int getType(String typeName) throws OdaException {
        String preparedTypeName = typeName.trim().toUpperCase();
        DataTypeMapping typeMapping = DataTypes.getManifest().getDataSetType(null).getDataTypeMapping(preparedTypeName);
        if (typeMapping != null) {
            return typeMapping.getNativeTypeCode();
        }
        throw new OdaException(String.valueOf(Messages.getString("dataTypes.typeNameInvalid")) + typeName);
    }

    public static String getTypeString(int type) throws OdaException {
        DataTypeMapping typeMapping = DataTypes.getManifest().getDataSetType(null).getDataTypeMapping(type);
        if (typeMapping != null) {
            return typeMapping.getNativeType();
        }
        throw new OdaException(String.valueOf(Messages.getString("dataTypes.typeNameInvalid")) + type);
    }

    public static boolean isValidType(String typeName) {
        String preparedTypeName = typeName.trim().toUpperCase();
        DataTypeMapping typeMapping = null;
        try {
            typeMapping = DataTypes.getManifest().getDataSetType(null).getDataTypeMapping(preparedTypeName);
        }
        catch (OdaException odaException) {
            // empty catch block
        }
        return typeMapping != null;
    }

    private static ExtensionManifest getManifest() throws OdaException {
        return ManifestExplorer.getInstance().getExtensionManifest(XML_DATA_SOURCE_ID);
    }

    private DataTypes() {
    }
}

