/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.actions.popup;

import java.io.IOException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.CatalogUtil;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SaveOfflineAction
extends AbstractAction {
    private static final String SAVE_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.UPDATE_OFFLINE");
    private static final String SAVE_JOB_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.UPDATE_OFFLINE_JOB");
    private static final ISchedulingRule MUTEX = new ISchedulingRule(){

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        IConnectionProfile connection = (IConnectionProfile)((IStructuredSelection)this.event.getSelection()).getFirstElement();
        Properties prop = connection.getProperties("offlineMode");
        this.setEnabled(connection.isConnected() && connection.getManagedConnection(org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo.class.getName()) != null && (prop == null || prop.isEmpty()));
    }

    public void initialize() {
        this.initializeAction(null, null, SAVE_NAME, SAVE_NAME);
    }

    public void run() {
        IConnectionProfile connection = (IConnectionProfile)((IStructuredSelection)this.event.getSelection()).getFirstElement();
        if (connection.isConnected()) {
            UpdateJob j = new UpdateJob(connection);
            j.setUser(true);
            j.schedule();
        }
    }

    private class UpdateJob
    extends Job {
        private Database database;
        private ConnectionInfo connectionInfo;

        public UpdateJob(IConnectionProfile profile) {
            super(SAVE_JOB_NAME);
            IManagedConnection connection = profile.getManagedConnection((class$org$eclipse$datatools$connectivity$sqm$core$connection$ConnectionInfo == null ? (class$org$eclipse$datatools$connectivity$sqm$core$connection$ConnectionInfo = SaveOfflineAction.class$("org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo")) : class$org$eclipse$datatools$connectivity$sqm$core$connection$ConnectionInfo).getName());
            this.connectionInfo = (ConnectionInfo)connection.getConnection().getRawConnection();
            this.database = this.connectionInfo.getSharedDatabase();
            this.setRule(MUTEX);
        }

        public boolean belongsTo(Object family) {
            return family == SAVE_JOB_NAME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask(SAVE_JOB_NAME + " - " + this.connectionInfo.getName(), 100);
                monitor.worked(5);
                new CatalogUtil().load((EObject)this.database, monitor, 90);
                if (!monitor.isCanceled()) {
                    monitor.subTask("");
                    this.connectionInfo.cacheDatabase(this.database);
                }
            }
            catch (IOException e) {
                IStatus iStatus = Status.CANCEL_STATUS;
                return iStatus;
            }
            finally {
                monitor.done();
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

