/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.actions.popup;

import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IPropertySetChangeEvent;
import org.eclipse.datatools.connectivity.IPropertySetListener;
import org.eclipse.datatools.connectivity.ProfileRule;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfoImpl;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class WorkOfflineAction
extends AbstractAction {
    private static final String TITLE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.OFFLINE.TITLE");
    private static final String MESSAGE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.OFFLINE.MESSAGE");
    private static final String OFFLINE_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.WORKOFFLINE");
    private static final String OFFLINE_JOB_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.WORKOFFLINE_JOB");
    private static Properties connectedStateProperty = new Properties();
    private static Properties disconnectedProperty = new Properties();
    static /* synthetic */ Class class$org$eclipse$datatools$connectivity$sqm$internal$core$connection$ConnectionFactory;

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        IConnectionProfile connection = (IConnectionProfile)((IStructuredSelection)this.event.getSelection()).getFirstElement();
        this.setEnabled(!connection.isConnected());
    }

    public void initialize() {
        this.initializeAction(null, null, OFFLINE_NAME, OFFLINE_NAME);
    }

    public void run() {
        IConnectionProfile connection = (IConnectionProfile)((IStructuredSelection)this.event.getSelection()).getFirstElement();
        ConnectionJob j = new ConnectionJob(connection);
        j.setUser(true);
        j.schedule();
    }

    private class ConnectionJob
    extends UIJob {
        private IConnectionProfile connection;

        public ConnectionJob(IConnectionProfile connection) {
            super(OFFLINE_JOB_NAME);
            this.connection = connection;
            this.setRule((ISchedulingRule)new ProfileRule(this.connection));
        }

        public boolean belongsTo(Object family) {
            return family == OFFLINE_JOB_NAME;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInUIThread(IProgressMonitor monitor) {
            try {
                block9: {
                    block8: {
                        monitor.beginTask(this.getName(), 100);
                        ConnectionInfoImpl info = new ConnectionInfoImpl(this.connection, class$org$eclipse$datatools$connectivity$sqm$internal$core$connection$ConnectionFactory == null ? (class$org$eclipse$datatools$connectivity$sqm$internal$core$connection$ConnectionFactory = WorkOfflineAction.class$("org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFactory")) : class$org$eclipse$datatools$connectivity$sqm$internal$core$connection$ConnectionFactory, false);
                        monitor.worked(40);
                        Database database = info.getCachedDatabase();
                        monitor.worked(80);
                        if (database == null) break block8;
                        try {
                            connectedStateProperty.put("connected", Boolean.toString(false));
                            this.connection.setProperties(IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET, connectedStateProperty);
                            disconnectedProperty.put("ConnectionInfo", info);
                            this.connection.setProperties("offlineMode", disconnectedProperty);
                            info.setSharedDatabase(database);
                            connectedStateProperty.put("connected", Boolean.toString(true));
                            this.connection.setProperties(IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET, connectedStateProperty);
                        }
                        catch (Throwable throwable) {
                            this.connection.addPropertySetListener(new IPropertySetListener(this){
                                private final /* synthetic */ ConnectionJob this$1;
                                {
                                    this.this$1 = this$1;
                                }

                                public void propertySetChanged(IPropertySetChangeEvent event) {
                                    if (IConnectionProfile.CONNECTION_PROFILE_PROPERTY_SET.equals(event.getPropertySetType()) && event.getChangedProperty("connected") != null && !Boolean.valueOf(event.getChangedProperty("connected").getNewValue()).booleanValue()) {
                                        ConnectionJob.access$300(this.this$1).setProperties("offlineMode", new Properties());
                                        WorkOfflineAction.access$200().clear();
                                        WorkOfflineAction.access$100().clear();
                                    }
                                }
                            });
                            throw throwable;
                        }
                        this.connection.addPropertySetListener(new /* invalid duplicate definition of identical inner class */);
                        break block9;
                    }
                    MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)TITLE, (String)MESSAGE);
                }
                if (monitor.isCanceled()) {
                    IStatus iStatus = Status.CANCEL_STATUS;
                    return iStatus;
                }
                monitor.worked(100);
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        static /* synthetic */ IConnectionProfile access$300(ConnectionJob x0) {
            return x0.connection;
        }
    }
}

