/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionSharingListener;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ConnectionNodeUtil;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ServerExplorerConnectionSharingListener;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ServerExplorerInitializer;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ServerNotFoundException;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.swt.widgets.Display;

public class ServerExplorerConnectionManagedListener {
    private static final IServicesManager manager = IServicesManager.INSTANCE;
    private Map sharingListenerMap = new HashMap();

    private ConnectionInfo getConnectionInfo(String name) {
        Iterator iterator = this.sharingListenerMap.keySet().iterator();
        while (iterator.hasNext()) {
            ConnectionInfo info = (ConnectionInfo)iterator.next();
            if (!info.getName().equals(name)) continue;
            return info;
        }
        return null;
    }

    private void removeConnectionFromMap(ConnectionInfo info) {
        if (this.sharingListenerMap.containsKey(info)) {
            System.out.println("Removing Info from map");
            ConnectionSharingListener listener = (ConnectionSharingListener)this.sharingListenerMap.get(info);
            info.removeConnectionSharingListener(listener);
            this.sharingListenerMap.remove(info);
        }
    }

    public void dispose() {
    }

    public void connectionInfoCreated(final ConnectionInfo info) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                System.out.println("connectionInfoCreated");
                if (!ServerExplorerConnectionManagedListener.this.sharingListenerMap.containsKey(info)) {
                    System.out.println("Adding new Info to Map");
                    ServerExplorerConnectionSharingListener listener = new ServerExplorerConnectionSharingListener();
                    info.addConnectionSharingListener((ConnectionSharingListener)listener);
                    ServerExplorerConnectionManagedListener.this.sharingListenerMap.put(info, listener);
                    new ServerExplorerInitializer().displayNewConnection(info.getName(), info);
                }
            }
        });
    }

    public void connectionInfoRemoved(final String name) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                System.out.println("connectionInfoRemoved");
                ConnectionInfo info = ServerExplorerConnectionManagedListener.this.getConnectionInfo(name);
                ServerExplorerConnectionManagedListener.this.removeConnectionFromMap(info);
                if (info != null) {
                    try {
                        IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                        IServicesManager.INSTANCE.getServerExplorerContentService().deleteServer(new IConnectionNode[]{node});
                    }
                    catch (ServerNotFoundException serverNotFoundException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public void connectionInfoRenamed(String previousName, ConnectionInfo info) {
        System.out.println("connectionInfoRenamed");
    }

    public void connected(final ConnectionInfo info, Connection connection) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                System.out.println("connected");
                new ServerExplorerInitializer().displayNewConnection(info.getName(), info);
            }
        });
    }

    public void disconnected(final ConnectionInfo info, Connection connection) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                try {
                    System.out.println("disconnected");
                    IConnectionNode connectionNode = ConnectionNodeUtil.getConnectionNode(info);
                    IServicesManager.INSTANCE.getServerExplorerContentService().disconnectServers(new IConnectionNode[]{connectionNode});
                }
                catch (ServerNotFoundException serverNotFoundException) {
                    // empty catch block
                }
            }
        });
    }
}

