/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.LinkedList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.virtual.IConnectionNode;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionSharingListener;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.ServerUIPlugin;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.dialogs.SQLExceptionDialog;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ConnectionNodeUtil;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ServerNotFoundException;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerStatusDecorationService;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.swt.widgets.Display;

public class ServerExplorerConnectionSharingListener
implements ConnectionSharingListener {
    private static final String SQLMESSAGE = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.CONNECTION.SQLEXCEPTION.SQLMESSAGE");

    private void disconnect(ConnectionInfo info) {
    }

    private void reconnect(ConnectionInfo info) {
    }

    private IStatus[] getStatus(SQLException sqlException) {
        LinkedList<Status> statusList = new LinkedList<Status>();
        SQLException current = sqlException;
        do {
            statusList.add(new Status(4, ServerUIPlugin.getDefault().getBundle().getSymbolicName(), current.getErrorCode(), current.getMessage(), (Throwable)current));
        } while ((current = current.getNextException()) != null);
        return statusList.toArray(new IStatus[statusList.size()]);
    }

    public void sharedConnectionAdded(ConnectionInfo info, Connection connection) {
    }

    public void sharedConnectionRemove(ConnectionInfo info, Connection connection) {
    }

    public void sharedDatabaseAdded(final ConnectionInfo info, final Database database) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                    node.shouldDisconnect(false);
                    IServicesManager.INSTANCE.getServerExplorerContentService().addNode(node, database);
                    IServerStatusDecorationService service = IServicesManager.INSTANCE.getServerStatusDecorationService();
                    if (service != null) {
                        service.refreshDecoration(new Object[]{node});
                    }
                }
                catch (ServerNotFoundException serverNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    public void sharedDatabaseRemove(final ConnectionInfo info, final Database database) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    IConnectionNode node = ConnectionNodeUtil.getConnectionNode(info);
                    node.shouldDisconnect(true);
                    IServicesManager.INSTANCE.getServerExplorerContentService().removeNode(node, database);
                }
                catch (ServerNotFoundException serverNotFoundException) {
                    // empty catch block
                }
            }
        });
    }

    public void onSQLException(ConnectionInfo info, Connection connection, SQLException exception) {
        if (info.getSharedConnection() != connection || exception instanceof SQLWarning) {
            return;
        }
        MultiStatus status = new MultiStatus(ServerUIPlugin.getDefault().getBundle().getSymbolicName(), exception.getErrorCode(), this.getStatus(exception), SQLMESSAGE, null);
        SQLExceptionDialog dialog = new SQLExceptionDialog((IStatus)status);
        dialog.open();
        if (dialog.getReturnCode() == 2) {
            this.disconnect(info);
        } else if (dialog.getReturnCode() == 1) {
            this.disconnect(info);
            this.reconnect(info);
        }
    }
}

