/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout;

import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.services.IVirtualNodeServiceFactory;
import org.eclipse.datatools.connectivity.sqm.core.ui.explorer.virtual.IVirtualNode;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.content.ServerExplorerConfiguration;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.ServerExplorerManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.impl.ServerExplorerContentProviderNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.IServerExplorerLayoutProviderNav;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.content.layout.IServerExplorerOnDemandContentProviderNav;

public abstract class AbstractLayoutProviderNav
implements IServerExplorerLayoutProviderNav {
    protected static final IVirtualNodeServiceFactory virtualNodeFactory = IDataToolsUIServiceManager.INSTANCE.getVirtualNodeServiceFactory();
    protected IServerExplorerOnDemandContentProviderNav onDemandContentProvider;
    protected ServerExplorerContentProviderNav contentProvider;

    protected AbstractLayoutProviderNav(ServerExplorerContentProviderNav contentProvider) {
        this.contentProvider = contentProvider;
    }

    protected void addChilds(Object parent, Object[] childs) {
        if (parent instanceof IVirtualNode) {
            int n = childs.length;
            for (int i = 0; i < n; ++i) {
                ((IVirtualNode)parent).addChildren(childs[i]);
            }
        }
    }

    protected Object findElement(Object[] viewers, Object element, int depth) {
        int n = viewers.length;
        for (int i = 0; i < n; ++i) {
            if (depth == 2 && viewers[i] instanceof IVirtualNode) {
                Object[] depthChilds = ((IVirtualNode)viewers[i]).getChildrenArray();
                int m = depthChilds.length;
                for (int k = 0; k < m; ++k) {
                    Object obj = depthChilds[k];
                    if (!obj.equals(element)) continue;
                    return obj;
                }
                continue;
            }
            if (!viewers[i].equals(element)) continue;
            return viewers[i];
        }
        return null;
    }

    public Object[] getChildren(Object parentElement) {
        return this.onDemandContentProvider.getChildren(parentElement);
    }

    public void initializeKnownServers(Object parent) {
        ConnectionInfo[] infos = new ServerExplorerConfiguration().getRestoredConnections();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            ServerExplorerManager.INSTANCE.initializeConnectionInfo(infos[i]);
        }
    }

    public void initializeDiscoveredServers(Object parent) {
    }

    public Object[] displayServerChildren(Object server) {
        return this.onDemandContentProvider.getChildren(server);
    }
}

