/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.util;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.connectivity.sqm.core.containment.ContainmentService;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class CatalogUtil {
    private static final String LOADING = ResourceLoader.getResourceLoader().queryString("DATATOOLS.CORE.UI.LOADING");

    public void load(EObject obj, IProgressMonitor monitor, int task) {
        this.loadInternal(obj, monitor, task, true);
        Iterator it = obj.eClass().getEAllStructuralFeatures().iterator();
        while (it.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)it.next();
            if (feature.isDerived() || feature.isTransient()) continue;
            obj.eGet(feature);
        }
    }

    public void loadWithoutAttributes(EObject obj, IProgressMonitor monitor, int task) {
        this.loadInternal(obj, monitor, task, false);
        Iterator it = obj.eClass().getEAllReferences().iterator();
        while (it.hasNext()) {
            EStructuralFeature feature = (EStructuralFeature)it.next();
            if (feature.isDerived() || feature.isTransient()) continue;
            obj.eGet(feature);
        }
    }

    private double loadInternal(EObject object, IProgressMonitor monitor, double task, boolean includingAttributes) {
        ContainmentService containmentService = RDBCorePlugin.getDefault().getContainmentService();
        Collection c = containmentService.getContainedElements(object);
        double acc = 0.0;
        if (c.size() != 0) {
            double delta = task / (double)c.size();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                String name;
                EObject child = (EObject)it.next();
                if (containmentService.isDisplayableElement(child) && child instanceof ENamedElement && (name = ((ENamedElement)child).getName()) != null) {
                    String type = IDataToolsUIServiceManager.INSTANCE.getLabelService(child).getDisplayType();
                    name = "<" + type + "> " + name;
                    monitor.subTask(LOADING + " " + name);
                }
                acc += this.loadInternal(child, monitor, delta, includingAttributes);
                if (monitor.isCanceled()) {
                    return 0.0;
                }
                if (!(acc >= 1.0)) continue;
                monitor.worked((int)acc);
                acc -= (double)((int)acc);
            }
        } else {
            acc = task;
        }
        if (includingAttributes) {
            Iterator it = object.eClass().getEAllStructuralFeatures().iterator();
            while (it.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)it.next();
                if (feature.isDerived() || feature.isTransient()) continue;
                object.eGet(feature);
            }
        } else {
            Iterator it = object.eClass().getEAllReferences().iterator();
            while (it.hasNext()) {
                EStructuralFeature feature = (EStructuralFeature)it.next();
                if (feature.isDerived() || feature.isTransient()) continue;
                object.eGet(feature);
            }
        }
        return acc;
    }
}

