/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.core.internal.ui.widgets;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DataContainerContentProvider
implements ITreeContentProvider {
    private boolean showClosedProjects = true;
    private String[] fileFilter = new String[0];
    private boolean showFiles = true;
    private String[] projectNatureFilter = new String[0];
    private String[] filesToExclude = new String[0];

    public void dispose() {
    }

    public Object[] getChildren(Object element) {
        IContainer container;
        Object[] theChildren = new Object[]{};
        if (element instanceof IWorkspace) {
            int i;
            IProject[] allProjects = ((IWorkspace)element).getRoot().getProjects();
            if (this.showClosedProjects) {
                theChildren = allProjects;
            } else {
                ArrayList<IProject> accessibleProjects = new ArrayList<IProject>();
                for (i = 0; i < allProjects.length; ++i) {
                    if (!allProjects[i].isOpen()) continue;
                    accessibleProjects.add(allProjects[i]);
                }
                theChildren = accessibleProjects.toArray();
            }
            if (this.projectNatureFilter.length > 0) {
                ArrayList<Object> filteredProjects = new ArrayList<Object>();
                for (i = 0; i < theChildren.length; ++i) {
                    try {
                        boolean isProjectAllowed = false;
                        for (int natureIndex = 0; natureIndex < this.projectNatureFilter.length; ++natureIndex) {
                            if (((IProject)theChildren[i]).isNatureEnabled(this.projectNatureFilter[natureIndex])) {
                                isProjectAllowed = true;
                            }
                            if (!isProjectAllowed) continue;
                            filteredProjects.add(theChildren[i]);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                theChildren = filteredProjects.toArray();
            }
        } else if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
            try {
                ArrayList<IResource> children = new ArrayList<IResource>();
                IResource[] members = container.members();
                for (int i = 0; i < members.length; ++i) {
                    if (members[i].getType() != 1) {
                        children.add(members[i]);
                    }
                    if (!this.showFiles || members[i].getType() != 1 || !this.satisfiesFileFilter((IFile)members[i]) || !this.satifiesExcludedFiles((IFile)members[i])) continue;
                    children.add(members[i]);
                }
                theChildren = children.toArray();
            }
            catch (CoreException e) {
                // empty catch block
            }
        }
        return theChildren;
    }

    private boolean satisfiesFileFilter(IFile resource) {
        boolean isSatisfied = false;
        if (this.fileFilter == null || this.fileFilter.length == 0) {
            isSatisfied = true;
        } else {
            for (int index = 0; index < this.fileFilter.length; ++index) {
                if (resource.getFileExtension() == null || !this.fileFilter[index].toLowerCase().equals(resource.getFileExtension().toLowerCase())) continue;
                isSatisfied = true;
            }
        }
        return isSatisfied;
    }

    private boolean satifiesExcludedFiles(IFile resource) {
        boolean isSatisfied = false;
        if (this.filesToExclude == null || this.filesToExclude.length == 0) {
            isSatisfied = true;
        } else {
            boolean isExcluded = false;
            for (int index = 0; index < this.filesToExclude.length; ++index) {
                if (!this.filesToExclude[index].equals(resource.getFullPath().toOSString())) continue;
                isExcluded = true;
            }
            if (!isExcluded) {
                isSatisfied = true;
            }
        }
        return isSatisfied;
    }

    public Object[] getElements(Object element) {
        return this.getChildren(element);
    }

    public Object getParent(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void showClosedProjects(boolean show) {
        this.showClosedProjects = show;
    }

    public void showFiles(boolean show) {
        this.showFiles = show;
    }

    public void setFileFilter(String[] filter) {
        this.fileFilter = filter;
    }

    public void setProjectNatureFilter(String[] naturesToShow) {
        this.projectNatureFilter = naturesToShow;
    }

    public void setExcludedFiles(String[] filesToExclude) {
        this.filesToExclude = filesToExclude;
    }
}

