/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.util.manifest;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.nls.Messages;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.JavaRuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;
import org.eclipse.datatools.connectivity.oda.util.manifest.Relationship;
import org.eclipse.datatools.connectivity.oda.util.manifest.RuntimeInterface;
import org.eclipse.datatools.connectivity.oda.util.manifest.TraceLogging;

public class ExtensionManifest {
    public static final String CLASS_ATTRIBUTE_NAME = "driverClass";
    private String m_namespace;
    private String m_dataSourceElementId;
    private String m_odaVersion;
    private String m_displayName;
    private RuntimeInterface m_runtime;
    private Hashtable m_dataSetTypes;
    private TraceLogging m_traceLogging;
    private Property[] m_properties = null;
    private Properties m_propsVisibility;
    private IConfigurationElement m_dataSourceElement;
    private IExtension m_dataSourceExtn;
    private Relationship m_relationship;
    static final /* synthetic */ boolean $assertionsDisabled;

    ExtensionManifest(IExtension dataSourceExtn) throws OdaException {
        this.init(dataSourceExtn);
    }

    protected ExtensionManifest() {
    }

    protected void init(IExtension dataSourceExtn) throws OdaException {
        IConfigurationElement[] propertiesElements;
        this.m_dataSourceElement = ManifestExplorer.getDataSourceElement(dataSourceExtn);
        if (!$assertionsDisabled && this.m_dataSourceElement == null) {
            throw new AssertionError();
        }
        this.m_namespace = dataSourceExtn.getContributor().getName();
        this.m_dataSourceElementId = this.m_dataSourceElement.getAttribute("id");
        if (this.m_dataSourceElementId == null || this.m_dataSourceElementId.length() == 0) {
            throw new OdaException(Messages.manifest_NO_DATA_SOURCE_EXTN_ID_DEFINED);
        }
        this.m_odaVersion = this.m_dataSourceElement.getAttribute("odaVersion");
        this.m_displayName = ManifestExplorer.getElementDisplayName(this.m_dataSourceElement);
        String driverClass = this.m_dataSourceElement.getAttribute(CLASS_ATTRIBUTE_NAME);
        if (driverClass == null) {
            throw new OdaException(Messages.bind((String)Messages.manifest_NO_DRIVER_CLASS_DEFINED, (Object)this.m_dataSourceElementId));
        }
        String needSetThreadContextClassLoader = this.m_dataSourceElement.getAttribute("setThreadContextClassLoader");
        if (needSetThreadContextClassLoader == null || needSetThreadContextClassLoader.length() == 0) {
            needSetThreadContextClassLoader = "false";
        } else if (!needSetThreadContextClassLoader.equalsIgnoreCase("true") && !needSetThreadContextClassLoader.equalsIgnoreCase("false")) {
            throw new OdaException(Messages.bind((String)Messages.manifest_INVALID_SET_THREAD_CONTEXT_CLASSLOADER_VALUE, (Object)needSetThreadContextClassLoader, (Object)this.m_dataSourceElementId));
        }
        this.m_runtime = new JavaRuntimeInterface(driverClass, Boolean.valueOf(needSetThreadContextClassLoader), this.m_namespace);
        this.m_dataSetTypes = ManifestExplorer.getDataSetElements(dataSourceExtn, this.m_dataSourceElementId);
        IConfigurationElement[] traceLogging = this.m_dataSourceElement.getChildren("traceLogging");
        int numOfTraceLogging = traceLogging.length;
        if (numOfTraceLogging > 0) {
            this.m_traceLogging = new TraceLogging(traceLogging[numOfTraceLogging - 1], this.m_dataSourceElementId);
        }
        if ((propertiesElements = this.m_dataSourceElement.getChildren("properties")).length > 0) {
            IConfigurationElement propertiesElement = propertiesElements[propertiesElements.length - 1];
            this.m_properties = ExtensionManifest.getPropertyDefinitions(propertiesElement);
            this.m_propsVisibility = ExtensionManifest.getPropertyVisibilities(propertiesElement);
        }
        this.m_relationship = Relationship.createInstance(this.m_dataSourceElement);
        this.m_dataSourceExtn = dataSourceExtn;
    }

    protected IExtension getDataSourceExtension() {
        return this.m_dataSourceExtn;
    }

    static Property[] getPropertyDefinitions(IConfigurationElement propertiesElement) throws OdaException {
        IConfigurationElement[] propGroupElements;
        IConfigurationElement[] propElements = propertiesElement.getChildren("property");
        int numProperties = propElements.length + (propGroupElements = propertiesElement.getChildren("propertyGroup")).length;
        if (numProperties <= 0) {
            return new Property[0];
        }
        ArrayList<Property> properties = new ArrayList<Property>();
        int size = propElements.length;
        for (int i = 0; i < size; ++i) {
            IConfigurationElement propElement = propElements[i];
            properties.add(new Property(propElement));
        }
        int size2 = propGroupElements.length;
        for (int j = 0; j < size2; ++j) {
            IConfigurationElement propGroupElement = propGroupElements[j];
            String groupName = propGroupElement.getAttribute("name");
            String groupDisplayName = ManifestExplorer.getElementDisplayName(propGroupElement);
            IConfigurationElement[] groupedPropElements = propGroupElement.getChildren("property");
            int size3 = groupedPropElements.length;
            for (int i = 0; i < size3; ++i) {
                IConfigurationElement groupedPropElement = groupedPropElements[i];
                properties.add(new Property(groupedPropElement, groupName, groupDisplayName));
            }
        }
        return properties.toArray(new Property[properties.size()]);
    }

    static Properties getPropertyVisibilities(IConfigurationElement propertiesElement) throws OdaException {
        IConfigurationElement[] propVisibilityElements = propertiesElement.getChildren("propertyVisibility");
        if (propVisibilityElements.length == 0) {
            return null;
        }
        Properties propsVisibility = new Properties();
        int size = propVisibilityElements.length;
        for (int i = 0; i < size; ++i) {
            IConfigurationElement propVisibltyElement = propVisibilityElements[i];
            String propName = propVisibltyElement.getAttribute("name");
            String propVisbility = propVisibltyElement.getAttribute("visibility");
            propsVisibility.setProperty(propName, propVisbility);
        }
        return propsVisibility;
    }

    public String getNamespace() {
        return this.m_namespace;
    }

    public String getExtensionID() {
        return this.getDataSourceElementID();
    }

    public String getDataSourceElementID() {
        return this.m_dataSourceElementId;
    }

    public IConfigurationElement getDataSourceElement() {
        return this.m_dataSourceElement;
    }

    public URL getDriverLocation() throws IOException {
        return this.m_runtime.getLibraryLocation();
    }

    public String getOdaVersion() {
        return this.m_odaVersion;
    }

    public String getDataSourceDisplayName() {
        return this.m_displayName;
    }

    public DataSetType[] getDataSetTypes() {
        Collection dataSetTypes = this.m_dataSetTypes.values();
        int size = dataSetTypes.size();
        return dataSetTypes.toArray(new DataSetType[size]);
    }

    public String[] getDataSetTypeIDs() {
        Set dataSetTypeIDs = this.m_dataSetTypes.keySet();
        int size = dataSetTypeIDs.size();
        return dataSetTypeIDs.toArray(new String[size]);
    }

    public int getDataSetTypeCount() {
        return this.m_dataSetTypes.size();
    }

    public DataSetType getDataSetType(String dataSetElementID) throws OdaException {
        if (dataSetElementID == null) {
            if (this.m_dataSetTypes.size() != 1) {
                this.throwsIllegalArgumentOdaException(dataSetElementID);
            }
            Collection dataSetTypes = this.m_dataSetTypes.values();
            if (!$assertionsDisabled && dataSetTypes.size() != 1) {
                throw new AssertionError();
            }
            return (DataSetType)dataSetTypes.toArray()[0];
        }
        DataSetType dsType = (DataSetType)this.m_dataSetTypes.get(dataSetElementID);
        if (dsType == null) {
            this.throwsIllegalArgumentOdaException(dataSetElementID);
        }
        return dsType;
    }

    private void throwsIllegalArgumentOdaException(String arg) throws OdaException {
        IllegalArgumentException illegalArg = new IllegalArgumentException(arg);
        OdaException ex = new OdaException(illegalArg.toString());
        ex.initCause(illegalArg);
        throw ex;
    }

    public TraceLogging getTraceLogging() {
        return this.m_traceLogging;
    }

    public RuntimeInterface getRuntimeInterface() {
        return this.m_runtime;
    }

    public Property[] getProperties() {
        if (this.m_properties == null) {
            this.m_properties = new Property[0];
        }
        return this.m_properties;
    }

    public Property[] getVisibleProperties() {
        return ManifestUtil.getVisiblePropertiesDefn(this.getProperties(), this.getPropertiesVisibility());
    }

    public Property[] getHiddenProperties() {
        return ManifestUtil.getHiddenPropertiesDefn(this.getProperties(), this.getPropertiesVisibility());
    }

    public Property getProperty(String propertyName) {
        if (propertyName == null || propertyName.length() == 0) {
            return null;
        }
        Property[] props = this.getProperties();
        for (int i = 0; i < props.length; ++i) {
            if (!propertyName.equals(props[i].getName())) continue;
            return props[i];
        }
        return null;
    }

    public Properties getPropertiesVisibility() {
        if (this.m_propsVisibility == null) {
            this.m_propsVisibility = new Properties();
        }
        return this.m_propsVisibility;
    }

    public boolean isDeprecated() {
        return this.m_relationship != null && this.m_relationship.isDeprecated();
    }

    public String getRelatedDataSourceId() {
        if (this.m_relationship == null) {
            return null;
        }
        return this.m_relationship.getRelatedId();
    }

    static {
        $assertionsDisabled = !ExtensionManifest.class.desiredAssertionStatus();
    }
}

