/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.postgresql.profile;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.datatools.connectivity.DriverConnectionBase;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;

public class PostgreSQLJDBCConnection
extends DriverConnectionBase {
    public static final String TECHNOLOGY_ROOT_KEY = "postgresql_jdbc";
    public static final String TECHNOLOGY_NAME = "PostgreSQL JDBC Connection";
    private Version mTechVersion = Version.NULL_VERSION;
    private Version mServerVersion = Version.NULL_VERSION;
    private String mServerName;

    public PostgreSQLJDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
        this.open();
    }

    protected Object createConnection(ClassLoader cl) throws Throwable {
        Properties props = this.getConnectionProfile().getBaseProperties();
        Properties connectionProps = new Properties();
        String driverClass = this.getDriverDefinition().getProperty("org.eclipse.datatools.connectivity.db.driverClass");
        String connectURL = props.getProperty("org.eclipse.datatools.connectivity.db.URL");
        String uid = props.getProperty("org.eclipse.datatools.connectivity.db.username");
        String pwd = props.getProperty("org.eclipse.datatools.connectivity.db.password");
        String nameValuePairs = props.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
        String propDelim = ",";
        if (uid != null) {
            connectionProps.setProperty("user", uid);
        }
        if (pwd != null) {
            connectionProps.setProperty("password", pwd);
        }
        if (nameValuePairs != null && nameValuePairs.length() > 0) {
            String[] pairs = this.parseString(nameValuePairs, ",");
            String addPairs = "";
            for (int i = 0; i < pairs.length; ++i) {
                String[] namevalue = this.parseString(pairs[i], "=");
                connectionProps.setProperty(namevalue[0], namevalue[1]);
                if (i == 0 || i < pairs.length - 1) {
                    addPairs = addPairs + propDelim;
                }
                addPairs = addPairs + pairs[i];
            }
        }
        Driver jdbcDriver = (Driver)cl.loadClass(driverClass).newInstance();
        return jdbcDriver.connect(connectURL, connectionProps);
    }

    public void close() {
        Connection connection = (Connection)this.getRawConnection();
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public String getProviderName() {
        return this.mServerName;
    }

    public Version getProviderVersion() {
        return this.mServerVersion;
    }

    protected String getTechnologyRootKey() {
        return TECHNOLOGY_ROOT_KEY;
    }

    public String getTechnologyName() {
        return TECHNOLOGY_NAME;
    }

    public Version getTechnologyVersion() {
        return this.mTechVersion;
    }

    protected void initVersions() {
        try {
            DatabaseMetaData dbmd = ((Connection)this.getRawConnection()).getMetaData();
            try {
                this.mServerName = dbmd.getDatabaseProductName();
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                String[] versionComps;
                String versionString = dbmd.getDatabaseProductVersion();
                if (versionString.indexOf(47) > 0 && (versionComps = versionString.split("/", 4)).length > 2) {
                    versionString = versionComps[1];
                    if (versionComps.length > 3) {
                        versionString = versionString + '.' + (versionComps[2].startsWith("EBF") ? versionComps[2].substring(3).trim() : versionComps[2]);
                    }
                    if (versionComps[0].length() > 0 && !versionComps[0].equals(this.mServerName)) {
                        this.mServerName = versionComps[0];
                    }
                }
                this.mServerVersion = Version.valueOf((String)versionString);
            }
            catch (Throwable e) {
                // empty catch block
            }
            try {
                this.mTechVersion = new Version(dbmd.getJDBCMajorVersion(), dbmd.getJDBCMinorVersion(), 0, new String());
            }
            catch (Throwable throwable) {}
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected String[] parseString(String str_list, String token) {
        StringTokenizer tk = new StringTokenizer(str_list, token);
        String[] pieces = new String[tk.countTokens()];
        int index = 0;
        while (tk.hasMoreTokens()) {
            pieces[index++] = tk.nextToken();
        }
        return pieces;
    }
}

