/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import java.util.ResourceBundle;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.actions.SQLInformationProvider;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;

public class InformationDispatchAction
extends TextEditorAction {
    private final TextOperationAction _fTextOperationAction;
    private IInformationProvider _informationProvider;

    public InformationDispatchAction(ResourceBundle resourceBundle, String prefix, TextOperationAction textOperationAction, SQLEditor editor) {
        super(resourceBundle, prefix, (ITextEditor)editor);
        if (textOperationAction == null) {
            throw new IllegalArgumentException();
        }
        this._fTextOperationAction = textOperationAction;
    }

    public void run() {
        ITextViewerExtension4 extension4;
        ISourceViewer sourceViewer = ((SQLEditor)this.getTextEditor()).getSV();
        if (sourceViewer == null) {
            this._fTextOperationAction.run();
            return;
        }
        if (sourceViewer instanceof ITextViewerExtension4 && (extension4 = (ITextViewerExtension4)sourceViewer).moveFocusToWidgetToken()) {
            return;
        }
        if (!(sourceViewer instanceof ITextViewerExtension2)) {
            this._fTextOperationAction.run();
            return;
        }
        ITextViewerExtension2 textViewerExtension2 = (ITextViewerExtension2)sourceViewer;
        ITextHover textHover = textViewerExtension2.getCurrentTextHover();
        if (textHover == null) {
            this._fTextOperationAction.run();
            return;
        }
        Point hoverEventLocation = textViewerExtension2.getHoverEventLocation();
        int offset = this.computeOffsetAtLocation((ITextViewer)sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
        if (offset == -1) {
            this._fTextOperationAction.run();
            return;
        }
        if (this._informationProvider == null) {
            this._informationProvider = new SQLInformationProvider((IEditorPart)((SQLEditor)this.getTextEditor()));
        }
        InformationPresenter fInformationPresenter = ((SQLEditor)this.getTextEditor()).getInformationPresenter();
        fInformationPresenter.setOffset(offset);
        fInformationPresenter.setInformationProvider(this._informationProvider, "__dftl_partition_content_type");
        fInformationPresenter.showInformation();
    }

    private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y) {
        StyledText styledText = textViewer.getTextWidget();
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return -1;
        }
        try {
            int widgetLocation = styledText.getOffsetAtLocation(new Point(x, y));
            if (textViewer instanceof ITextViewerExtension5) {
                ITextViewerExtension5 extension = (ITextViewerExtension5)textViewer;
                return extension.widgetOffset2ModelOffset(widgetLocation);
            }
            IRegion visibleRegion = textViewer.getVisibleRegion();
            return widgetLocation + visibleRegion.getOffset();
        }
        catch (IllegalArgumentException e) {
            return -1;
        }
    }
}

