/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions.Messages;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.connection.ConnectionInfoDialog;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class SetConnectionInfoAction
extends TextEditorAction {
    SQLScrapbookEditor _sqlEditor;

    public SetConnectionInfoAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
        this._sqlEditor = (SQLScrapbookEditor)editor;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.datatools.sqltools.sqleditor.attach_connection_profile_action");
    }

    public void run() {
        ConnectionInfoDialog dlg;
        if (this._sqlEditor.isDirty()) {
            String message = NLS.bind((String)Messages.EditorManager_saveChangesQuestion, (Object)this._sqlEditor.getTitle());
            String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog d = new MessageDialog(null, Messages.Save_Resource, null, message, 3, buttons, 0);
            int choice = d.open();
            switch (choice) {
                case 0: {
                    IRunnableWithProgress progressOp = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) {
                            SetConnectionInfoAction.this._sqlEditor.doSave(monitor);
                        }
                    };
                    try {
                        SqlscrapbookPlugin.getActiveWorkbenchWindow().run(false, true, progressOp);
                        break;
                    }
                    catch (InvocationTargetException e) {
                        Throwable targetExc = e.getTargetException();
                        String title = NLS.bind((String)Messages.EditorManager_operationFailed, (Object)Messages.Save);
                        MessageDialog.openError(null, (String)Messages.common_error, (String)(title + ':' + targetExc.getMessage()));
                        break;
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                case 1: {
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if ((dlg = new ConnectionInfoDialog(this._sqlEditor.getEditorSite().getShell(), this._sqlEditor.getConnectionInfo())).open() != 1) {
            this._sqlEditor.setConnectionInfo(dlg.getConnectionInfo());
        }
    }
}

