/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor;

import java.util.ResourceBundle;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.externalfile.ExternalSQLFileEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SqlscrapbookPlugin;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.actions.SetConnectionInfoAction;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.Messages;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorStorageEditorInput;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SQLScrapbookEditor
extends SQLEditor {
    public static final String EDITOR_ID = "org.eclipse.datatools.sqltools.sqlscrapbook.SQLScrapbookEditor";
    protected ProfileStatusChecker _profileChecker = new ProfileStatusChecker();
    private IAction _setConnectionInfoAction;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.getSite().getPage().addPartListener((IPartListener2)this._profileChecker);
    }

    protected void initializeEditor() {
        super.initializeEditor();
        this.setDocumentProvider(SqlscrapbookPlugin.getDefault().getSQLEditorDocumentProvider());
    }

    public void doSetInput(IEditorInput input) throws CoreException {
        Object newInput = null;
        if (input instanceof SQLScrapbookEditorInput) {
            newInput = (SQLScrapbookEditorInput)input;
        } else if (input instanceof IFileEditorInput) {
            newInput = new SQLScrapbookEditorInput(((IFileEditorInput)input).getFile());
        } else if (input instanceof IPathEditorInput) {
            IFileStore store = EFS.getLocalFileSystem().getStore(((IPathEditorInput)input).getPath());
            newInput = new ExternalSQLFileEditorInput(store);
        } else if (input instanceof ILocationProvider) {
            IFileStore store = EFS.getLocalFileSystem().getStore(((ILocationProvider)input).getPath((Object)input));
            newInput = new ExternalSQLFileEditorInput(store);
        }
        if (newInput == null) {
            super.doSetInput(input);
        } else {
            if (input instanceof SQLScrapbookEditorInput) {
                newInput.setEditorSite(this.getEditorSite());
            }
            super.doSetInput((IEditorInput)newInput);
        }
    }

    protected void createActions() {
        super.createActions();
        ResourceBundle bundle = Messages.getBundleForConstructedKeys();
        this._setConnectionInfoAction = new SetConnectionInfoAction(bundle, "SetConnectionInfo.", (ITextEditor)this);
        this.setAction("org.eclipse.datatools.sqltools.sqleditor.attachProfileAction", this._setConnectionInfoAction);
    }

    protected void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        menu.add((IContributionItem)new Separator());
        this.addAction(menu, "org.eclipse.datatools.sqltools.sqleditor.attachProfileAction");
    }

    public void requestConnection() {
        this._setConnectionInfoAction.run();
    }

    public void setConnectionInfo(ISQLEditorConnectionInfo connInfo) {
        super.setConnectionInfo(connInfo);
        if (this.getEditorInput() instanceof IFileEditorInput) {
            SQLFileUtil.setEncodedConnectionInfo(((IFileEditorInput)this.getEditorInput()).getFile(), connInfo.encode());
        }
        this.setTitleToolTip(this.getTitleToolTip());
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removePartListener((IPartListener2)this._profileChecker);
    }

    public void doSave(IProgressMonitor monitor) {
        if (this.getEditorInput() instanceof SQLEditorStorageEditorInput) {
            this.doSaveAs();
        } else {
            super.doSave(monitor);
        }
    }

    private class ProfileStatusChecker
    implements IPartListener2 {
        private ProfileStatusChecker() {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            switch (SQLScrapbookEditor.this.getConnectionInfo().getProfileStatus()) {
                case 1: 
                case 4: {
                    if (SQLScrapbookEditor.this.isDirty()) {
                        SQLScrapbookEditor.this._setConnectionInfoAction.run();
                        break;
                    }
                    SQLScrapbookEditor.this.close(false);
                    break;
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    }
}

