/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.modelbase.sql.schema.impl;

import java.util.Collection;
import org.eclipse.datatools.modelbase.sql.accesscontrol.AuthorizationIdentifier;
import org.eclipse.datatools.modelbase.sql.constraints.Assertion;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.datatypes.CharacterSet;
import org.eclipse.datatools.modelbase.sql.datatypes.UserDefinedType;
import org.eclipse.datatools.modelbase.sql.routines.BuiltInFunction;
import org.eclipse.datatools.modelbase.sql.routines.Procedure;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.routines.UserDefinedFunction;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLSchemaPackage;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.schema.Sequence;
import org.eclipse.datatools.modelbase.sql.schema.impl.SQLObjectImpl;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class SchemaImpl
extends SQLObjectImpl
implements Schema {
    private static final long serialVersionUID = 1L;
    protected EList triggers = null;
    protected EList indices = null;
    protected EList tables = null;
    protected EList sequences = null;
    protected Database database = null;
    protected Catalog catalog = null;
    protected EList assertions = null;
    protected EList userDefinedTypes = null;
    protected EList charSets = null;
    protected EList routines = null;
    protected AuthorizationIdentifier owner = null;

    protected SchemaImpl() {
    }

    protected EClass eStaticClass() {
        return SQLSchemaPackage.Literals.SCHEMA;
    }

    public EList getTriggers() {
        if (this.triggers == null) {
            this.triggers = new EObjectWithInverseResolvingEList(Trigger.class, (InternalEObject)this, 6, 6);
        }
        return this.triggers;
    }

    public EList getIndices() {
        if (this.indices == null) {
            this.indices = new EObjectWithInverseResolvingEList(Index.class, (InternalEObject)this, 7, 6);
        }
        return this.indices;
    }

    public EList getTables() {
        if (this.tables == null) {
            this.tables = new EObjectWithInverseResolvingEList(Table.class, (InternalEObject)this, 8, 9);
        }
        return this.tables;
    }

    public EList getSequences() {
        if (this.sequences == null) {
            this.sequences = new EObjectWithInverseResolvingEList(Sequence.class, (InternalEObject)this, 9, 9);
        }
        return this.sequences;
    }

    public Database getDatabase() {
        if (this.database != null && this.database.eIsProxy()) {
            InternalEObject oldDatabase = (InternalEObject)this.database;
            this.database = (Database)this.eResolveProxy(oldDatabase);
            if (this.database != oldDatabase && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 10, (Object)oldDatabase, (Object)this.database));
            }
        }
        return this.database;
    }

    public Database basicGetDatabase() {
        return this.database;
    }

    public NotificationChain basicSetDatabase(Database newDatabase, NotificationChain msgs) {
        Database oldDatabase = this.database;
        this.database = newDatabase;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldDatabase, (Object)newDatabase);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setDatabase(Database newDatabase) {
        if (newDatabase != this.database) {
            NotificationChain msgs = null;
            if (this.database != null) {
                msgs = ((InternalEObject)this.database).eInverseRemove((InternalEObject)this, 8, Database.class, msgs);
            }
            if (newDatabase != null) {
                msgs = ((InternalEObject)newDatabase).eInverseAdd((InternalEObject)this, 8, Database.class, msgs);
            }
            if ((msgs = this.basicSetDatabase(newDatabase, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)newDatabase, (Object)newDatabase));
        }
    }

    public Catalog getCatalog() {
        if (this.catalog != null && this.catalog.eIsProxy()) {
            InternalEObject oldCatalog = (InternalEObject)this.catalog;
            this.catalog = (Catalog)this.eResolveProxy(oldCatalog);
            if (this.catalog != oldCatalog && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 11, (Object)oldCatalog, (Object)this.catalog));
            }
        }
        return this.catalog;
    }

    public Catalog basicGetCatalog() {
        return this.catalog;
    }

    public NotificationChain basicSetCatalog(Catalog newCatalog, NotificationChain msgs) {
        Catalog oldCatalog = this.catalog;
        this.catalog = newCatalog;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldCatalog, (Object)newCatalog);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setCatalog(Catalog newCatalog) {
        if (newCatalog != this.catalog) {
            NotificationChain msgs = null;
            if (this.catalog != null) {
                msgs = ((InternalEObject)this.catalog).eInverseRemove((InternalEObject)this, 7, Catalog.class, msgs);
            }
            if (newCatalog != null) {
                msgs = ((InternalEObject)newCatalog).eInverseAdd((InternalEObject)this, 7, Catalog.class, msgs);
            }
            if ((msgs = this.basicSetCatalog(newCatalog, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newCatalog, (Object)newCatalog));
        }
    }

    public EList getAssertions() {
        if (this.assertions == null) {
            this.assertions = new EObjectWithInverseResolvingEList(Assertion.class, (InternalEObject)this, 12, 10);
        }
        return this.assertions;
    }

    public EList getUserDefinedTypes() {
        if (this.userDefinedTypes == null) {
            this.userDefinedTypes = new EObjectWithInverseResolvingEList(UserDefinedType.class, (InternalEObject)this, 13, 6);
        }
        return this.userDefinedTypes;
    }

    public EList getCharSets() {
        if (this.charSets == null) {
            this.charSets = new EObjectWithInverseResolvingEList(CharacterSet.class, (InternalEObject)this, 14, 9);
        }
        return this.charSets;
    }

    public EList getRoutines() {
        if (this.routines == null) {
            this.routines = new EObjectWithInverseResolvingEList(Routine.class, (InternalEObject)this, 15, 18);
        }
        return this.routines;
    }

    public EList getProcedures() {
        return this.getSpecializedRoutines(Procedure.class);
    }

    public EList getUDFs() {
        return this.getSpecializedRoutines(UserDefinedFunction.class);
    }

    public EList getBuiltInFunctions() {
        return this.getSpecializedRoutines(BuiltInFunction.class);
    }

    protected EList getSpecializedRoutines(Class aDesiredClass) {
        BasicEList specializedRoutines = new BasicEList();
        EList routines = this.getRoutines();
        int routineCnt = routines.size();
        for (int i = 0; i < routineCnt; ++i) {
            Object obj = routines.get(i);
            if (!aDesiredClass.isAssignableFrom(obj.getClass())) continue;
            specializedRoutines.add(obj);
        }
        return specializedRoutines;
    }

    public AuthorizationIdentifier getOwner() {
        if (this.owner != null && this.owner.eIsProxy()) {
            InternalEObject oldOwner = (InternalEObject)this.owner;
            this.owner = (AuthorizationIdentifier)this.eResolveProxy(oldOwner);
            if (this.owner != oldOwner && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 16, (Object)oldOwner, (Object)this.owner));
            }
        }
        return this.owner;
    }

    public AuthorizationIdentifier basicGetOwner() {
        return this.owner;
    }

    public NotificationChain basicSetOwner(AuthorizationIdentifier newOwner, NotificationChain msgs) {
        AuthorizationIdentifier oldOwner = this.owner;
        this.owner = newOwner;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 16, (Object)oldOwner, (Object)newOwner);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setOwner(AuthorizationIdentifier newOwner) {
        if (newOwner != this.owner) {
            NotificationChain msgs = null;
            if (this.owner != null) {
                msgs = ((InternalEObject)this.owner).eInverseRemove((InternalEObject)this, 6, AuthorizationIdentifier.class, msgs);
            }
            if (newOwner != null) {
                msgs = ((InternalEObject)newOwner).eInverseAdd((InternalEObject)this, 6, AuthorizationIdentifier.class, msgs);
            }
            if ((msgs = this.basicSetOwner(newOwner, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, (Object)newOwner, (Object)newOwner));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getTriggers()).basicAdd((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getIndices()).basicAdd((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getTables()).basicAdd((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getSequences()).basicAdd((Object)otherEnd, msgs);
            }
            case 10: {
                if (this.database != null) {
                    msgs = ((InternalEObject)this.database).eInverseRemove((InternalEObject)this, 8, Database.class, msgs);
                }
                return this.basicSetDatabase((Database)otherEnd, msgs);
            }
            case 11: {
                if (this.catalog != null) {
                    msgs = ((InternalEObject)this.catalog).eInverseRemove((InternalEObject)this, 7, Catalog.class, msgs);
                }
                return this.basicSetCatalog((Catalog)otherEnd, msgs);
            }
            case 12: {
                return ((InternalEList)this.getAssertions()).basicAdd((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getUserDefinedTypes()).basicAdd((Object)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getCharSets()).basicAdd((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getRoutines()).basicAdd((Object)otherEnd, msgs);
            }
            case 16: {
                if (this.owner != null) {
                    msgs = ((InternalEObject)this.owner).eInverseRemove((InternalEObject)this, 6, AuthorizationIdentifier.class, msgs);
                }
                return this.basicSetOwner((AuthorizationIdentifier)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getTriggers()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getIndices()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getTables()).basicRemove((Object)otherEnd, msgs);
            }
            case 9: {
                return ((InternalEList)this.getSequences()).basicRemove((Object)otherEnd, msgs);
            }
            case 10: {
                return this.basicSetDatabase(null, msgs);
            }
            case 11: {
                return this.basicSetCatalog(null, msgs);
            }
            case 12: {
                return ((InternalEList)this.getAssertions()).basicRemove((Object)otherEnd, msgs);
            }
            case 13: {
                return ((InternalEList)this.getUserDefinedTypes()).basicRemove((Object)otherEnd, msgs);
            }
            case 14: {
                return ((InternalEList)this.getCharSets()).basicRemove((Object)otherEnd, msgs);
            }
            case 15: {
                return ((InternalEList)this.getRoutines()).basicRemove((Object)otherEnd, msgs);
            }
            case 16: {
                return this.basicSetOwner(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getTriggers();
            }
            case 7: {
                return this.getIndices();
            }
            case 8: {
                return this.getTables();
            }
            case 9: {
                return this.getSequences();
            }
            case 10: {
                if (resolve) {
                    return this.getDatabase();
                }
                return this.basicGetDatabase();
            }
            case 11: {
                if (resolve) {
                    return this.getCatalog();
                }
                return this.basicGetCatalog();
            }
            case 12: {
                return this.getAssertions();
            }
            case 13: {
                return this.getUserDefinedTypes();
            }
            case 14: {
                return this.getCharSets();
            }
            case 15: {
                return this.getRoutines();
            }
            case 16: {
                if (resolve) {
                    return this.getOwner();
                }
                return this.basicGetOwner();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.getTriggers().clear();
                this.getTriggers().addAll((Collection)newValue);
                return;
            }
            case 7: {
                this.getIndices().clear();
                this.getIndices().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getTables().clear();
                this.getTables().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.getSequences().clear();
                this.getSequences().addAll((Collection)newValue);
                return;
            }
            case 10: {
                this.setDatabase((Database)newValue);
                return;
            }
            case 11: {
                this.setCatalog((Catalog)newValue);
                return;
            }
            case 12: {
                this.getAssertions().clear();
                this.getAssertions().addAll((Collection)newValue);
                return;
            }
            case 13: {
                this.getUserDefinedTypes().clear();
                this.getUserDefinedTypes().addAll((Collection)newValue);
                return;
            }
            case 14: {
                this.getCharSets().clear();
                this.getCharSets().addAll((Collection)newValue);
                return;
            }
            case 15: {
                this.getRoutines().clear();
                this.getRoutines().addAll((Collection)newValue);
                return;
            }
            case 16: {
                this.setOwner((AuthorizationIdentifier)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.getTriggers().clear();
                return;
            }
            case 7: {
                this.getIndices().clear();
                return;
            }
            case 8: {
                this.getTables().clear();
                return;
            }
            case 9: {
                this.getSequences().clear();
                return;
            }
            case 10: {
                this.setDatabase(null);
                return;
            }
            case 11: {
                this.setCatalog(null);
                return;
            }
            case 12: {
                this.getAssertions().clear();
                return;
            }
            case 13: {
                this.getUserDefinedTypes().clear();
                return;
            }
            case 14: {
                this.getCharSets().clear();
                return;
            }
            case 15: {
                this.getRoutines().clear();
                return;
            }
            case 16: {
                this.setOwner(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return this.triggers != null && !this.triggers.isEmpty();
            }
            case 7: {
                return this.indices != null && !this.indices.isEmpty();
            }
            case 8: {
                return this.tables != null && !this.tables.isEmpty();
            }
            case 9: {
                return this.sequences != null && !this.sequences.isEmpty();
            }
            case 10: {
                return this.database != null;
            }
            case 11: {
                return this.catalog != null;
            }
            case 12: {
                return this.assertions != null && !this.assertions.isEmpty();
            }
            case 13: {
                return this.userDefinedTypes != null && !this.userDefinedTypes.isEmpty();
            }
            case 14: {
                return this.charSets != null && !this.charSets.isEmpty();
            }
            case 15: {
                return this.routines != null && !this.routines.isEmpty();
            }
            case 16: {
                return this.owner != null;
            }
        }
        return super.eIsSet(featureID);
    }
}

