/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result.internal.core;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ProfileManager;
import org.eclipse.datatools.sqltools.result.IReExecutionRunnable;
import org.eclipse.datatools.sqltools.result.OperationCommand;

public class ReExecutionRegistryReader {
    public static IReExecutionRunnable readProperReExecutionHandler(OperationCommand cmd) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.eclipse.datatools.sqltools.result", "reExecuteScript");
        if (point == null) {
            return null;
        }
        IExtension[] extensions = point.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            for (int j = 0; j < elements.length; ++j) {
                String database_id = elements[j].getAttribute("database_id");
                String consumer_name = elements[j].getAttribute("consumer_name");
                IConnectionProfile profile = ProfileManager.getInstance().getProfileByName(cmd.getProfileName());
                if (profile == null || !cmd.getConsumerName().equals(consumer_name) || !profile.getProviderId().equals(database_id)) continue;
                try {
                    IReExecutionRunnable reExecutionRunnable = (IReExecutionRunnable)elements[j].createExecutableExtension("class");
                    return reExecutionRunnable;
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return null;
    }
}

