/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.flatfile.util;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.util.ULocale;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.connectivity.oda.flatfile.util.DateFormatter;

class DateFormatUtil {
    private static void loadULocaleInstanceFromLocale(Set uLocales) {
        Locale[] ls = Locale.getAvailableLocales();
        for (int i = 0; i < ls.length; ++i) {
            uLocales.add(ULocale.forLocale((Locale)ls[i]));
        }
    }

    private static void loadULocaleInstanceFromULocale(Set uLocales) {
        ULocale[] uls = ULocale.getAvailableLocales();
        for (int i = 0; i < uls.length; ++i) {
            uLocales.add(uls[i]);
        }
    }

    private static ULocale[] populateULocaleCache() {
        HashSet uLocales = new HashSet();
        DateFormatUtil.loadULocaleInstanceFromULocale(uLocales);
        DateFormatUtil.loadULocaleInstanceFromLocale(uLocales);
        ULocale[] AllULocales = new ULocale[uLocales.size()];
        Object[] localeArray = uLocales.toArray();
        for (int i = 0; i < AllULocales.length; ++i) {
            AllULocales[i] = (ULocale)localeArray[i];
        }
        return AllULocales;
    }

    private DateFormatUtil() {
    }

    static Map getAllDateFormatter() {
        HashMap<ULocale, DateFormatter> reMap = new HashMap<ULocale, DateFormatter>(80);
        ULocale[] AllULocales = DateFormatUtil.populateULocaleCache();
        for (int i = 0; i < AllULocales.length; ++i) {
            reMap.put(AllULocales[i], new DateFormatter(AllULocales[i]));
        }
        return reMap;
    }

    static Map getAllDateFormat() {
        HashMap<String, DateFormat> reMap = new HashMap<String, DateFormat>(240);
        ULocale[] AllULocales = DateFormatUtil.populateULocaleCache();
        for (int i = 0; i < AllULocales.length; ++i) {
            for (int dateStyle = 1; dateStyle <= 3; ++dateStyle) {
                DateFormat dateFormat = DateFormat.getDateInstance((int)dateStyle, (ULocale)AllULocales[i]);
                dateFormat.setLenient(false);
                String key = String.valueOf(dateStyle) + ":" + AllULocales[i].getName();
                reMap.put(key, dateFormat);
            }
        }
        return reMap;
    }

    static Map getAllDateTimeFormat() {
        HashMap<String, DateFormat> reMap = new HashMap<String, DateFormat>(720);
        ULocale[] AllULocales = DateFormatUtil.populateULocaleCache();
        for (int i = 0; i < AllULocales.length; ++i) {
            for (int dateStyle = 1; dateStyle <= 3; ++dateStyle) {
                for (int timeStyle = 1; timeStyle <= 3; ++timeStyle) {
                    DateFormat dateFormat = DateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (ULocale)AllULocales[i]);
                    dateFormat.setLenient(false);
                    String key = String.valueOf(dateStyle) + ":" + String.valueOf(timeStyle) + ":" + AllULocales[i].getName();
                    reMap.put(key, dateFormat);
                }
            }
        }
        return reMap;
    }
}

