/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.internal.core.connection;

import java.util.Collections;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionFilter;

public class ConnectionFilterImpl
implements ConnectionFilter {
    private static final long serialVersionUID = 3689626986939299641L;
    private String predicate;
    private IFilter filter;

    public ConnectionFilterImpl() {
    }

    public ConnectionFilterImpl(String predicate) {
        this.setPredicate(predicate);
    }

    public void setPredicate(String predicate) {
        this.filter = null;
        this.predicate = predicate;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public boolean isValid(String predicate) {
        return predicate != null && predicate.length() > 0;
    }

    public String getPattern() {
        String pattern = "";
        if (this.predicate != null) {
            try {
                pattern = this.predicate.indexOf("(") < 0 ? this.predicate.substring(this.predicate.indexOf("'"), this.predicate.length()) : this.predicate.substring(this.predicate.indexOf("("), this.predicate.length());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pattern;
    }

    public String getOperator() {
        String operator = "";
        if (this.predicate != null) {
            try {
                operator = this.predicate.indexOf("(") < 0 ? this.predicate.substring(0, this.predicate.indexOf("'")).trim() : this.predicate.substring(0, this.predicate.indexOf("(")).trim();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return operator;
    }

    public String[] getPatternElements() {
        Object[] elements = new String[]{};
        Vector<String> patternVector = new Vector<String>();
        String pattern = this.getPattern();
        String[] patterns = pattern.split("'");
        for (int i = 0; i < patterns.length; ++i) {
            if (patterns[i].equals(", ") || patterns[i].equals("(") || patterns[i].equals(")")) continue;
            patternVector.add(patterns[i]);
        }
        elements = new String[patternVector.size()];
        patternVector.copyInto(elements);
        return elements;
    }

    public boolean isOperatorInclusive() {
        boolean isInclusive = false;
        if (this.getOperator().equals("IN")) {
            isInclusive = true;
        }
        return isInclusive;
    }

    public boolean isOperatorExclusive() {
        boolean isExclusive = false;
        if (this.getOperator().equals("NOT IN")) {
            isExclusive = true;
        }
        return isExclusive;
    }

    public boolean isFiltered(String name) {
        if (this.filter == null) {
            this.createFilter();
        }
        return this.filter.isFiltered(name);
    }

    private void createFilter() {
        String operator = this.getOperator();
        if ("LIKE".equals(operator)) {
            this.filter = new LikeFilter(this.getPattern());
        } else if ("NOT LIKE".equals(operator)) {
            this.filter = new NotLikeFilter(this.getPattern());
        } else if ("IN".equals(operator)) {
            this.filter = new InFilter(this.getPattern());
        } else if ("NOT IN".equals(operator)) {
            this.filter = new NotInFilter(this.getPattern());
        }
    }

    private static class NotInFilter
    extends InFilter {
        NotInFilter(String pattern) {
            super(pattern);
        }

        public boolean isFiltered(String name) {
            return !super.isFiltered(name);
        }
    }

    private static class InFilter
    implements IFilter {
        Set values;

        InFilter(String pattern) {
            if (pattern == null || pattern.length() < 2) {
                this.values = Collections.EMPTY_SET;
            } else {
                this.values = new TreeSet();
                StringTokenizer tokenizer = new StringTokenizer(pattern.substring(1, pattern.length() - 1).replaceAll("'", ""), ",");
                while (tokenizer.hasMoreTokens()) {
                    this.values.add(tokenizer.nextToken());
                }
            }
        }

        public boolean isFiltered(String name) {
            return this.values.contains(name);
        }
    }

    private static class NotLikeFilter
    extends LikeFilter {
        NotLikeFilter(String pattern) {
            super(pattern);
        }

        public boolean isFiltered(String name) {
            return !super.isFiltered(name);
        }
    }

    private static class LikeFilter
    implements IFilter {
        Pattern pattern;

        LikeFilter(String pattern) {
            String regex = pattern == null || pattern.length() < 2 ? new String() : pattern.substring(1, pattern.length() - 1).replace('%', '*').replace('_', '?');
            this.pattern = Pattern.compile(regex);
        }

        public boolean isFiltered(String name) {
            return this.pattern.matcher(name).matches();
        }
    }

    private static interface IFilter {
        public boolean isFiltered(String var1);
    }
}

