/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.loader;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.jdbc.JDBCCatalog;
import org.eclipse.datatools.connectivity.sqm.loader.CatalogFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.IConnectionFilterProvider;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCBaseLoader;
import org.eclipse.datatools.modelbase.sql.schema.Catalog;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class JDBCCatalogLoader
extends JDBCBaseLoader {
    public static final String COLUMN_TABLE_CAT = "TABLE_CAT";
    static final /* synthetic */ boolean $assertionsDisabled;

    public JDBCCatalogLoader(ICatalogObject catalogObject) {
        this(catalogObject, new CatalogFilterProvider());
    }

    public JDBCCatalogLoader(ICatalogObject catalogObject, IConnectionFilterProvider connectionFilterProvider) {
        super(catalogObject, connectionFilterProvider);
        if (!$assertionsDisabled && !(catalogObject instanceof Database)) {
            throw new AssertionError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection loadCatalogs() throws SQLException {
        ArrayList<Catalog> retVal = new ArrayList<Catalog>();
        ResultSet rs = null;
        try {
            Catalog catalog;
            this.initActiveFilter();
            rs = this.createResultSet();
            while (rs.next()) {
                catalog = this.processRow(rs);
                if (catalog == null) continue;
                retVal.add(catalog);
            }
            if (retVal.size() == 0) {
                catalog = this.createCatalog();
                catalog.setName(new String());
                retVal.add(catalog);
            }
            ArrayList<Catalog> arrayList = retVal;
            return arrayList;
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    public void clearCatalogs(Collection catalogs) {
        catalogs.clear();
    }

    protected ResultSet createResultSet() throws SQLException {
        return this.getCatalogObject().getConnection().getMetaData().getCatalogs();
    }

    protected void closeResultSet(ResultSet rs) {
        try {
            rs.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Catalog processRow(ResultSet rs) throws SQLException {
        String catalogName = rs.getString(COLUMN_TABLE_CAT);
        if (catalogName == null || this.isFiltered(catalogName)) {
            return null;
        }
        Catalog catalog = this.createCatalog();
        this.initialize(catalog, rs);
        return catalog;
    }

    protected Catalog createCatalog() {
        return new JDBCCatalog();
    }

    protected void initialize(Catalog catalog, ResultSet rs) throws SQLException {
        catalog.setName(rs.getString(COLUMN_TABLE_CAT));
    }

    protected Database getDatabase() {
        return (Database)this.getCatalogObject();
    }

    static {
        $assertionsDisabled = !JDBCCatalogLoader.class.desiredAssertionStatus();
    }
}

