/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.dse.actions;

import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.ui.actions.RefreshViewAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;

public class RefreshActionProvider
extends CommonActionProvider {
    private StructuredViewer aViewer;
    private IStructuredSelection selection;
    private RefreshViewAction addRefreshAction;

    private void makeActions() {
        this.addRefreshAction = new RefreshViewAction(this.aViewer);
        this.addRefreshAction.setActionDefinitionId("org.eclipse.ui.file.refresh");
    }

    private void setSelection(IStructuredSelection selection) {
        this.selection = selection;
    }

    public void setActionContext(ActionContext aContext) {
        if (aContext.getSelection() instanceof IStructuredSelection) {
            this.setSelection((IStructuredSelection)aContext.getSelection());
        }
    }

    public void fillContextMenu(IMenuManager manager) {
        boolean hasSelection = false;
        if (this.selection != null && this.selection.getFirstElement() != null) {
            hasSelection = true;
        }
        if (hasSelection) {
            boolean isCategory = this.selection.getFirstElement() instanceof ICategory;
            boolean isProfile = this.selection.getFirstElement() instanceof IConnectionProfile;
            if (!isCategory && !isProfile) {
                this.addRefreshAction.setEnabled(false);
            } else {
                this.addRefreshAction.setEnabled(true);
            }
            manager.insertAfter("slot3", (IAction)this.addRefreshAction);
        }
    }

    public void fillActionBars(IActionBars bars) {
        bars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.addRefreshAction);
        this.updateActionBars();
    }

    public void init(ICommonActionExtensionSite aConfig) {
        this.aViewer = aConfig.getStructuredViewer();
        this.makeActions();
    }

    public void setContext(ActionContext context) {
        super.setContext(context);
        if (context != null && context.getSelection() instanceof IStructuredSelection) {
            this.setSelection((IStructuredSelection)context.getSelection());
        }
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.addRefreshAction.selectionChanged((IAction)this.addRefreshAction, (ISelection)selection);
    }
}

