/**
 * Created on 2004-10-15
 *
 * Copyright (c) Sybase, Inc. 2004-2006 All rights reserved.
 */
package org.eclipse.datatools.sqltools.sqleditor.internal.actions;

import java.util.ResourceBundle;

import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension2;
import org.eclipse.jface.text.ITextViewerExtension4;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.information.InformationPresenter;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.ui.texteditor.TextOperationAction;

/**
 * @author Hui Cao
 *
 */
/**
 * This action behaves in two different ways: If there is no current text hover, the javadoc is displayed using
 * information presenter. If there is a current text hover, it is converted into a information presenter in order to
 * make it sticky.
 */
public class InformationDispatchAction extends TextEditorAction
{

    /** The wrapped text operation action. */
    private final TextOperationAction _fTextOperationAction;
    private IInformationProvider _informationProvider;

    /**
	 * Creates a dispatch action.
	 * 
	 * @param resourceBundle the resource bundle
	 * @param prefix the prefix
	 * @param textOperationAction the text operation action
	 */
    public InformationDispatchAction(ResourceBundle resourceBundle, String prefix,
        final TextOperationAction textOperationAction, SQLEditor editor)
    {
        super(resourceBundle, prefix, editor);
        if (textOperationAction == null)
        {
            throw new IllegalArgumentException();
        }
        _fTextOperationAction = textOperationAction;
    }

    /*
	 * @see org.eclipse.jface.action.IAction#run()
	 */
    public void run()
    {

        ISourceViewer sourceViewer = ((SQLEditor) this.getTextEditor()).getSV();
        if (sourceViewer == null)
        {
            _fTextOperationAction.run();
            return;
        }

        if (sourceViewer instanceof ITextViewerExtension4)
        {
            ITextViewerExtension4 extension4 = (ITextViewerExtension4) sourceViewer;
            if (extension4.moveFocusToWidgetToken())
            return;
        }

        if (!(sourceViewer instanceof ITextViewerExtension2))
        {
            _fTextOperationAction.run();
            return;
        }

        ITextViewerExtension2 textViewerExtension2 = (ITextViewerExtension2) sourceViewer;

        // does a text hover exist?
        ITextHover textHover = textViewerExtension2.getCurrentTextHover();
        if (textHover == null)
        {
            _fTextOperationAction.run();
            return;				
            //		    textHover = new SQLErrorHover();
        }

        Point hoverEventLocation = textViewerExtension2.getHoverEventLocation();
        int offset = computeOffsetAtLocation(sourceViewer, hoverEventLocation.x, hoverEventLocation.y);
        if (offset == -1)
        {
            _fTextOperationAction.run();
            return;				
        }

        if (_informationProvider == null)
        {
            _informationProvider = new SQLInformationProvider((SQLEditor) getTextEditor());
        }
        InformationPresenter fInformationPresenter = ((SQLEditor) getTextEditor()).getInformationPresenter();
        fInformationPresenter.setOffset(offset);	
        fInformationPresenter.setInformationProvider(_informationProvider, IDocument.DEFAULT_CONTENT_TYPE);
        fInformationPresenter.showInformation();

    }

    // modified version from TextViewer
    private int computeOffsetAtLocation(ITextViewer textViewer, int x, int y)
    {

        StyledText styledText = textViewer.getTextWidget();
        IDocument document = textViewer.getDocument();

        if (document == null)
        {
            return -1;		
        }

        try
        {
            int widgetLocation = styledText.getOffsetAtLocation(new Point(x, y));
            if (textViewer instanceof ITextViewerExtension5)
            {
                ITextViewerExtension5 extension = (ITextViewerExtension5) textViewer;
                return extension.widgetOffset2ModelOffset(widgetLocation);
            }
            else
            {
                IRegion visibleRegion = textViewer.getVisibleRegion();
                return widgetLocation + visibleRegion.getOffset();
            }
        }
        catch (IllegalArgumentException e)
        {
            return -1;	
        }

    }
}
