/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result.internal.export;

import org.eclipse.datatools.sqltools.result.internal.ui.export.IResultConstants;

/**
 * Factory for outputter.
 * 
 * @author Dafan Yang
 */
public class OutputterFactory
{
    /**
     * Creates an outputter to output the result set(s) in given format
     * 
     * @param format the format of output file
     * @return an outputter
     */
    public static AbstractOutputter createOutputter(int format)
    {
        switch (format)
        {
            case IResultConstants.ID_PLAINTEXT:                
                return new TextOutputter();
            case IResultConstants.ID_CSV:
                return new CSVOutputter();
            case IResultConstants.ID_XML:
                return new XMLOutputter();
            case IResultConstants.ID_HTML:
                return new HTMLOutputter();
            default:
                return new TextOutputter();
        }
    }
}
