/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result.internal.ui.actions;

import org.eclipse.datatools.sqltools.result.IReExecutionRunnable;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.action.Action;

public class ReExecuteAction extends Action
{
    OperationCommand     _command;
    IReExecutionRunnable _runnable;

    public ReExecuteAction(OperationCommand cmd, IReExecutionRunnable runnable)
    {
        super();
        setText(Messages.ReExecuteAction_name); 
        _command = cmd;
        _runnable = runnable;
    }

    public void run()
    {
        super.run();
        IResultInstance ins = ResultsViewPlugin.getResultManager().getInstance(_command);

        // clear the original result first
        ins.increaseFrequency();
        ins.resetInstance();
        
        Runnable runnable = new Runnable()
        {
            public void run()
            {
                _runnable.reExecute(_command);
            }
        };

        // to prevent the client re-execution logic to block our UI, we use a brand new thread to re-execute this
        Thread thread = new Thread(runnable);
        thread.start();
    }

}
