/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result.internal.ui.actions;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.result.internal.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.ui.view.ColumnAlignedResultItem;
import org.eclipse.datatools.sqltools.result.internal.utils.ILogger;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.datatools.sqltools.result.internal.utils.StatusTextProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.IUpdate;

/**
 * @author Dafan Yang
 */
public class SaveResultInstanceAction extends Action implements IUpdate
{
    private static ILogger _log = ResultsViewPlugin.getLogger(null);
    Shell                  _shell;
    ISelectionProvider     _provider;

    /**
     * 
     */
    public SaveResultInstanceAction(Shell shell, ISelectionProvider selectionProvider)
    {
        super(Messages.SaveResultInstanceAction_save_history); 
        this._shell = shell;
        this._provider = selectionProvider;
    }

    public void update()
    {
        IStructuredSelection selection = (IStructuredSelection) _provider.getSelection();
        if (selection == null)
        {
            setEnabled(false);
            return;
        }
        Object[] obj = selection.toArray();
        if (obj == null || obj.length == 0 || obj.length > 1)
        {
            setEnabled(false);
            return;
        }
        if (!(obj[0] instanceof IResultInstance))
        {
            setEnabled(false);
            return;
        }
        setEnabled(true);
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.action.Action#run()
     */
    public void run()
    {
        IStructuredSelection selection = (IStructuredSelection) _provider.getSelection();
        Object[] obj = selection.toArray();
        if (obj == null || obj.length == 0 || obj.length > 1)
        {
            // should not happen
            return;
        }
        IResultInstance instance = (IResultInstance) obj[0];
        FileDialog dialog = new FileDialog(_shell, SWT.SAVE);
        dialog.setText(Messages.SaveResultInstanceAction_save_hisotry_title); 

        String filename = ""; //$NON-NLS-1$
        boolean selectAgain = false;
        do
        {
            filename = dialog.open();
            if (filename == null)
            {
                return;
            }
            File file = new File(filename);
            if (file.exists())
            {
                String[] buttons = new String[]
                {
                    IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL
                };
                String question = NLS.bind(Messages.ResultExportWizard_overwrite, new Object[] 
				{
				    filename
				});
                MessageDialog d = new MessageDialog(_shell, Messages.ResultExportWizard_question, 
                        null, question, MessageDialog.QUESTION, buttons, 0);
                int overwrite = d.open();
                switch (overwrite)
                {
                    case 0: // Yes
                        selectAgain = false;
                        break;
                    case 1: // No
                        selectAgain = true;
                        break;
                    case 2: // Cancel
                    default:
                        return;
                }
            }
        }
        while (selectAgain);

        try
        {
            FileOutputStream fos = new FileOutputStream(new File(filename));
            PrintWriter w = new PrintWriter(new BufferedWriter((new OutputStreamWriter(fos, "UTF-8"))));
            w.print(StatusTextProvider.getHistoryHeader(instance));
            w.println("---------------------------------------------------------------------------------------"); //$NON-NLS-1$
            w.println(""); //$NON-NLS-1$
            String dispStr = ColumnAlignedResultItem.getResultInstanceDispString(instance, ResultsViewPlugin
                    .getDefault().getPreferenceStore().getString(PreferenceConstants.SQL_RESULTS_VIEW_NULL_STRING)); //$NON-NLS-1$
            w.print(dispStr);
            w.close();
        }
        catch (IOException ex)
        {
            _log.error("SaveResultInstanceAction_cant_export_result_log", ex); //$NON-NLS-1$
            ErrorDialog
                    .openError(
                            _shell,
                            Messages.SaveResultInstanceAction_save_error, Messages.SaveResultInstanceAction_can_not_save, new Status(IStatus.ERROR, ResultsViewPlugin 
                                            .getPluginId(), 0, ex.getMessage(), ex));
        }
    }
}
