/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result.internal.ui.export;

import org.eclipse.datatools.sqltools.result.internal.utils.Messages;

/**
 * The constants for save/export result set(s) function
 * 
 * @author Dafan Yang
 */
public interface IResultConstants
{
    static public String         FORMAT_PLAIN                 = Messages.IResultConstants_plain_format; 
    static public String         FORMAT_CSV                   = Messages.IResultConstants_csv_format; 
    static public String         FORMAT_HTML                  = Messages.IResultConstants_html_format; 
    static public String         FORMAT_XML                   = Messages.IResultConstants_xml_format; 

    static public String         EXT_TXT                      = Messages.IResultConstants_text_ext; 
    static public String         EXT_CSV                      = Messages.IResultConstants_csv_ext; 
    static public String         EXT_HTML                     = Messages.IResultConstants_html_ext; 
    static public String         EXT_XML                      = Messages.IResultConstants_xml_ext; 
    static public String         EXT_ALL                      = Messages.IResultConstants_all_ext; 

    static public String         NAME_TXT                     = Messages.IResultConstants_text_name; 
    static public String         NAME_CSV                     = Messages.IResultConstants_csv_name; 
    static public String         NAME_HTML                    = Messages.IResultConstants_html_name; 
    static public String         NAME_XML                     = Messages.IResultConstants_xml_name; 
    static public String         NAME_ALL                     = Messages.IResultConstants_all_name; 

    public static String         COLUMN_ALIGNED               = Messages.ExportFormatPage_columndelimiter_items_columnaligned; //$NON-NLS-1$
    public static String         COMMA_SEPARATED              = Messages.ExportFormatPage_columndelimiter_items_commaseparated; //$NON-NLS-1$
    public static String         TAB_DELIMITED                = Messages.ExportFormatPage_columndelimiter_items_tabdelimited; //$NON-NLS-1$
    public static String         USER_DEFINED                 = Messages.ExportFormatPage_columndelimiter_items_userdefined; //$NON-NLS-1$
    public static String         CSV_SEPARATED                = Messages.ExportFormatPage_columndelimiter_items_csvseparated; //$NON-NLS-1$
    public static String         DEFAULT_DEMILITER            = Messages.ExportFormatPage_columndelimiter_userdefineddelimiter; //$NON-NLS-1$

    // the number of characters of user defined delimter
    public static int            USER_DEFINED_DELIMITER_COUNT = 5;

    // export properties for resultset
    public static String         DELIMITER                    = "delimiter"; //$NON-NLS-1$
    public static String         USERDEFINED_DELIMITER        = "userdefined_delimiter"; //$NON-NLS-1$
    public static String         ENCODING                     = "encoding"; //$NON-NLS-1$

    // delimiter strings for display
    public static String         DELIMITER_COLUMN             = "<column>"; //$NON-NLS-1$
    public static String         DELIMITER_COMMA              = ","; //$NON-NLS-1$
    public static String         DELIMITER_TAB                = "<tab>"; //$NON-NLS-1$

    static final public String[] OUTPUT_FORMATS               = new String[]
    {
        COLUMN_ALIGNED, COMMA_SEPARATED, TAB_DELIMITED, USER_DEFINED
    };

    static final String[]        FORMATS                      = new String[]
    {
        FORMAT_PLAIN, FORMAT_XML, FORMAT_HTML, FORMAT_CSV,
    };

    static final String[]        FORMATSNOHTML                = new String[]
    {
        FORMAT_PLAIN, FORMAT_XML
    };

    static final String[]        FORMATTEXTONLY               = new String[]
    {
                                                                  FORMAT_PLAIN
    };

    static public final int      ID_PLAINTEXT                 = 1;
    static public final int      ID_XML                       = 2;
    static public final int      ID_HTML                      = 3;
    static public final int      ID_CSV                       = 4;

    static final int[]           FORMAT_IDS                   = new int[]
    {
        ID_PLAINTEXT, ID_XML, ID_HTML, ID_CSV,
    };
    
    static final String[][]      EXT                          =
    {
        {
        IResultConstants.EXT_TXT, IResultConstants.EXT_ALL
        },
        {
        IResultConstants.EXT_XML, IResultConstants.EXT_ALL
        },
        {
        IResultConstants.EXT_HTML, IResultConstants.EXT_ALL
        },
        {
        IResultConstants.EXT_CSV, IResultConstants.EXT_ALL
        }
    };
    
    static final String[][]      NAME                         =
    {
        {
        IResultConstants.NAME_TXT, IResultConstants.NAME_ALL
        },
        {
        IResultConstants.NAME_XML, IResultConstants.NAME_ALL
        },
        {
        IResultConstants.NAME_HTML, IResultConstants.NAME_ALL
        },
        {
        IResultConstants.NAME_CSV, IResultConstants.NAME_ALL
        }
    };

    public static final String   RESOURCE_TYPE                = "resource"; //$NON-NLS-1$
}
