/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result.internal.ui.export.actions;


import org.eclipse.datatools.sqltools.result.internal.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.internal.ui.export.ResultExportWizard;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;

/**
 * Exports all the result set objects in a result instance into an external file
 * 
 *  @author Dafan Yang
 */
public class ExportAllResultSetsAction extends Action
{
    IResultInstance		_result;
    Shell				_shell;

    public ExportAllResultSetsAction(Shell shell, IResultInstance result)
    {
        super(Messages.AllResultSetAction_Title); 
        this._shell = shell;
        _result = result;
    }

    Shell getShell()
    {
        return _shell;
    }

    IResultInstance getResultSetObject()
    {
        return _result;
    }

    public void run()
    {
        WizardDialog dialog = new WizardDialog(getShell(), new ResultExportWizard(getResultSetObject()));
        dialog.open();
    }
}
