/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result.internal.ui.export.actions;

import org.eclipse.datatools.sqltools.result.IResultSetObject;
import org.eclipse.datatools.sqltools.result.internal.ui.export.SaveResultSetDialog;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Shell;

/**
 * Saves the result set object.
 * 
 * @author Dafan Yang
 */
public class SaveResultSetAction extends Action
{
    IResultSetObject _result;
    Shell            _shell;

    public SaveResultSetAction(Shell shell, IResultSetObject result)
    {
        super(Messages.ResultSetAction_Title); 
        this._shell = shell;
        _result = result;
    }

    Shell getShell()
    {
        return _shell;
    }

    IResultSetObject getResultSetObject()
    {
        return _result;
    }

    public void run()
    {
        SaveResultSetDialog dialog = new SaveResultSetDialog(getShell(), getResultSetObject());
        dialog.setOriginalName("result.txt");
        dialog.open();
    }
}
