/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.result.internal.ui.view;

import org.eclipse.datatools.sqltools.result.internal.PreferenceConstants;
import org.eclipse.datatools.sqltools.result.internal.ResultsViewPlugin;
import org.eclipse.datatools.sqltools.result.internal.utils.Images;
import org.eclipse.datatools.sqltools.result.internal.utils.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.texteditor.IUpdate;

/**
 * Switch the display mode between text and grid
 * 
 * @author Dafan Yang
 */
public class TextModeDisplayAction extends Action implements IUpdate
{
    public TextModeDisplayAction()
    {
        super();
        setImageDescriptor(Images.DESC_TEXT_MODE);
        setToolTipText(Messages.TextModeDisplayAction_textmode_tip);
    }

    public void run()
    {
        IPreferenceStore store = ResultsViewPlugin.getDefault().getPreferenceStore();
        boolean isText = store.getInt(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE) == 1;
        // 1. text mode; 2. grid mode
        if(isText)
        {
            store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE, 2);
        }
        else
        {
            store.setValue(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE, 1);
        }
    }

    public void update()
    {
        IPreferenceStore store = ResultsViewPlugin.getDefault().getPreferenceStore();
        boolean isText = store.getInt(PreferenceConstants.SQL_RESULTS_VIEW_DISPLAY_MODE) == 1;
        setChecked(isText);
    }
}
