/*******************************************************************************
 * Copyright (c) 2004, 2005 Sybase, Inc. and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.RoutineEditor;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.datatools.sqltools.routineeditor.ui.launching.SPLaunchShortcut;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorActionConstants;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.IHelpContextIds;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/**
 * @author Li Huang
 *
 */
public class DebugAction extends RoutineAction
{
    private SQLEditor     _sqlEditor;

    /**
	 * Constructs a default <code>DebugAction</code>. This happens
	 * when user invokes the context menu in DSE.
	 */
    public DebugAction()
    {
    	init();
    }

	/**
	 * Constructs a DebugAction from the selected resource. This
	 * happens when this action is instantiated by the common action provider.
	 */
	public DebugAction(Object selectedResource) {
		init();
		initSQLObject(this, selectedResource);
		initConnectionProfile();
		update();
	}
	

    /**
     * @param text
     * @param image
     */
    public DebugAction(SQLEditor targetEditor)
    {
        init();
        setActiveEditor(targetEditor);
        update();
    }

	protected void init() {
		setText(Messages.DebugAction_label);
        setToolTipText(Messages.DebugAction_tooltip);
        setImageDescriptor(RoutineEditorImages.getImageDescriptor("debug_exc"));
        setActionDefinitionId(ISQLEditorActionConstants.DEBUG_ACTION_ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, IHelpContextIds.DEBUG_ACTION);
	}

    public void setActiveEditor(SQLEditor targetEditor)
    {
        _sqlEditor = targetEditor;
    }

    public void run()
    {
		ProcIdentifier proc = null;
        if (_sqlEditor == null || _sqlEditor.getEditorInput() == null)
        {
            try
            {
    			proc = SQLDevToolsUtil.getProcIdentifier(
    					new DatabaseIdentifier(_connectionProfile.getName(),
    							getDatabaseName()), _sqlObject);
    			IWorkbenchPage page = PlatformUI.getWorkbench()
    					.getActiveWorkbenchWindow().getActivePage();
    			page.openEditor(new ProcEditorInput(proc),
    						RoutineEditor.EDITOR_ID);
            }
            catch (Exception e)
            {
            	RoutineEditorActivator.getDefault().log(e);
            }
        }
        else
        {
        	ProcEditorInput procEditorInput = (ProcEditorInput) _sqlEditor.getEditorInput();
        	proc = procEditorInput.getProcIdentifier();
        }
        if (proc != null)
        {
        	try
        	{
        		SPLaunchShortcut.launch( proc, ILaunchManager.DEBUG_MODE);
        	}
        	catch (Exception e)
        	{
        		RoutineEditorActivator.getDefault().log(Messages.DebugAction_runError, e);
        	}
       	
        }
        
        
    }

    public void update()
    {
        boolean enabled = false;
        String profileName = null;
        if (_sqlEditor != null && _sqlEditor.getConnectionInfo().getSharedConnection() != null && _sqlEditor.getEditorInput() instanceof ProcEditorInput)
        {
        	profileName = _sqlEditor.getConnectionInfo().getConnectionProfileName(); 
        	enabled = true;
        }
        else if (_sqlObject != null && _connectionProfile != null)
        {
        	enabled = true;
        	profileName = _connectionProfile.getName();
        }
        if (enabled)
        {
            try
            {
            	DatabaseIdentifier di = new DatabaseIdentifier(profileName); 
                enabled = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(di).supportsDebugging();
            }
            catch (Exception e)
            {
            	RoutineEditorActivator.getDefault().log(Messages.common_error, e);
                enabled = false;
            }
        }
        setEnabled(enabled);
    }

	public void run(IAction action) {
		run(null);
	}
}
