/*******************************************************************************
 * Copyright (c) 2004, 2005 Sybase, Inc. and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.RoutineEditor;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

/**
 * 
 * @author Hui Cao
 * 
 */
public class EditRoutineAction extends RoutineAction implements IActionDelegate {

	/**
	 * 
	 */
	public EditRoutineAction() {
		init();
	}

	/**
	 * Constructs a CommonSQLObjectAction from the selected resource. This
	 * happens when this action is instantiated by the common action provider.
	 */
	public EditRoutineAction(Object selectedResource) {
		init();
		initSQLObject(this, selectedResource);
		initConnectionProfile();
	}
	
	protected void init() {
		setText(Messages.EditRoutineAction_label);
    	setToolTipText(Messages.EditRoutineAction_tooltip);
        setImageDescriptor(RoutineEditorImages.getImageDescriptor("routine_editor"));
	}
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {
		run();
	}

	public void run() {
		if (_sqlObject != null && _connectionProfile != null) {
			ProcIdentifier proc = SQLDevToolsUtil.getProcIdentifier(
					new DatabaseIdentifier(_connectionProfile.getName(),
							getDatabaseName()), _sqlObject);
			IWorkbenchPage page = PlatformUI.getWorkbench()
					.getActiveWorkbenchWindow().getActivePage();
			try {
				page.openEditor(new ProcEditorInput(proc),
						RoutineEditor.EDITOR_ID);
			} catch (Exception e) {
				RoutineEditorActivator.getDefault().log(e);
			}
		}
	}
	
	
}