/**
 * Created on Jan. 7, 2005
 * 
 * Copyright (c) Sybase, Inc. 2004-2006 All rights reserved.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import java.util.ResourceBundle;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.routineeditor.IRoutineEditorDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.ProcEditorInput;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorActionConstants;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.IHelpContextIds;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

/**
 * @author Li Huang
 */
public class RefreshFromDatabaseAction extends TextEditorAction
{
    SQLEditor _sqlEditor;

    /**
     * @param bundle
     * @param prefix
     * @param editor
     */
    public RefreshFromDatabaseAction(ResourceBundle bundle, String prefix, ITextEditor editor)
    {
        super(bundle, prefix, editor);
        _sqlEditor = (SQLEditor) editor;
        setImageDescriptor(RoutineEditorImages.getImageDescriptor("refresh_from_database"));
        setActionDefinitionId(ISQLEditorActionConstants.REFRESH_FROM_DATABASE_ACTION_ID);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this, IHelpContextIds.REFRESH_FROM_DATABASE_ACTION);
    }

    public void run()
    {
        try
        {
        	IRoutineEditorDocumentProvider sqlEditorDocumentProvider = (IRoutineEditorDocumentProvider) _sqlEditor
                .getDocumentProvider();
            ProcIdentifier procIdentifier = ((ProcEditorInput) _sqlEditor.getEditorInput()).getProcIdentifier();
            IControlConnection controlConnection = EditorCorePlugin.getControlConnectionManager()
                .getOrCreateControlConnection(procIdentifier.getDatabaseIdentifier());
            sqlEditorDocumentProvider.refreshFromDatabase(_sqlEditor.getEditorInput(), controlConnection,
                procIdentifier);
            //Add status line message when the action 'refresh from database' succeeded.
            ((WorkbenchWindow) SQLEditorPlugin.getActiveWorkbenchWindow()).getStatusLineManager().setMessage(
                Messages.RefreshFromDatabase_success);

        }
        catch (Exception e)
        {
            try
            {
                throw new CoreException(new Status(IStatus.ERROR, RoutineEditorActivator.PLUGIN_ID, 0, NLS.bind(Messages.RefreshFromDatabase_fail,(new Object[]
                {
                    e.toString()
                }
                )), e));
            }
            catch (CoreException e1)
            {
            	RoutineEditorActivator.getDefault().log(e1);
            }

        }

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.texteditor.IUpdate#update()
     */
    public void update()
    {
        _sqlEditor = (SQLEditor) getTextEditor();
        if (_sqlEditor.getEditorInput() instanceof ProcEditorInput)
        {
            setEnabled(true);
        }
        else
        {
            setEnabled(false);
        }
    }

}
