/**
 * Created on Jan. 7, 2005
 * 
 * Copyright (c) Sybase, Inc. 2004-2006 All rights reserved.
 */
package org.eclipse.datatools.sqltools.routineeditor.ui.actions;

import java.util.ResourceBundle;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorImages;
import org.eclipse.datatools.sqltools.sqleditor.ISQLEditorActionConstants;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.IHelpContextIds;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

/**
 * @author Li Huang
 * 
 */
public class SaveToDatabaseAction extends TextEditorAction {
	SQLEditor _sqlEditor;

	/**
	 * @param bundle
	 * @param prefix
	 * @param editor
	 */
	public SaveToDatabaseAction(ResourceBundle bundle, String prefix,
			ITextEditor editor) {
		super(bundle, prefix, editor);
		_sqlEditor = (SQLEditor) editor;
		setImageDescriptor(RoutineEditorImages
				.getImageDescriptor("save_to_database"));
		setActionDefinitionId(ISQLEditorActionConstants.SAVE_TO_DATABASE_ACTION_ID);
		PlatformUI.getWorkbench().getHelpSystem().setHelp(this,
				IHelpContextIds.SAVE_TO_DATABASE_ACTION);
	}

	public void run() {
		_sqlEditor.doSave(new NullProgressMonitor());
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.ui.texteditor.IUpdate#update()
	 */
	public void update() {
		_sqlEditor = (SQLEditor) getTextEditor();
		if (_sqlEditor.isEditorInputReadOnly()) {
			setEnabled(false);
		} else {
			setEnabled(_sqlEditor.isDirty());
		}
	}
}
