/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.connectivity.internal.derby.catalog;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Iterator;

import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.datatools.modelbase.sql.tables.SQLTablesPackage;
import org.eclipse.datatools.modelbase.sql.tables.Table;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.datatools.modelbase.derby.DerbyModelPackage;
import org.eclipse.datatools.modelbase.derby.impl.SynonymImpl;

public class DerbyCatalogSynonym extends SynonymImpl implements ICatalogObject {
	private static final long serialVersionUID = 3257804259579074800L;
	public void refresh() {
		this.columnsLoaded = false;
		this.aliasedTableLoaded = false;
		RefreshManager.getInstance().referesh(this);
	}

	public boolean isSystemObject() {
		return false;
	}

	public Connection getConnection() {
		Database database = this.getCatalogDatabase();
		return ((DerbyCatalogDatabase) database).getConnection();
	}
	
	public Database getCatalogDatabase() {
		
		return this.getSchema().getDatabase();		
	}
	
	public EList getColumns() {
		if(!this.columnsLoaded) this.loadColumns();
		return this.columns;
	}

	
	public boolean eIsSet(EStructuralFeature eFeature) {
		int id = eDerivedStructuralFeatureID(eFeature);
		if(id == SQLTablesPackage.TABLE__COLUMNS) {
			this.getColumns();
		}
		else if(id == DerbyModelPackage.SYNONYM__DESCRIPTION) {
			this.getDescription();
		}
		else if(id == DerbyModelPackage.SYNONYM__TABLE) {
			this.getAliasedTable();
		}
		else if(id == DerbyModelPackage.SYNONYM__COLUMNS) {
			this.getColumns();
		}
		
		return super.eIsSet(eFeature);
	}
	
	private synchronized void loadColumns() {
		if(this.columnsLoaded) return;
		
		boolean deliver = this.eDeliver();
		this.eSetDeliver(false);
		try {
			DerbyCatalogTable.loadColumns(this.getConnection(), super.getColumns(), this.getAliasedTable());
		}
		catch(Exception e) {
		}
		this.columnsLoaded = true;
		this.eSetDeliver(deliver);
	}

	
	public Table getAliasedTable() {
		if(!this.aliasedTableLoaded) this.loadAliasedTable();
		return this.table;
	}
	
	static Column getColumn(Table table,String columnName) {
		Iterator it = table.getColumns().iterator();
		while(it.hasNext()) {
			Column c = (Column) it.next();
			if(c.getName().equals(columnName)) return c;
		}
		return null;
	}
	
	private Schema getSchema(String schemaName) {
		Schema s = this.getSchema();
		if(s.getName().equals(schemaName)) return s;
		Database d = s.getDatabase();
		Iterator it = d.getSchemas().iterator();
		while(it.hasNext()) {
			s = (Schema) it.next();
			if(s.getName().equals(schemaName)) return s;
		}
		Schema schema = new DerbyCatalogSchema();
		schema.setName(schemaName);
		schema.setDatabase(d);
		
		return schema;
	}

	private Table getTable(String schemaName, String tableName) {
		Schema schema = this.getSchema(schemaName);
		Iterator it = schema.getTables().iterator();
		while(it.hasNext()) {
			Table table = (Table) it.next();
			if(table.getName().equals(tableName)) return table;			
		}
		Table table = new DerbyCatalogTable();
		table.setName(tableName);
		table.setSchema(schema);
		return table;		
	}
	
	private synchronized void loadAliasedTable() {
		if(this.aliasedTableLoaded) return;
		Connection connection = this.getConnection();
		
		boolean deliver = this.eDeliver();
		this.eSetDeliver(false);	
		
		try {

			String query = "SELECT TABLENAME,TABLETYPE" + //$NON-NLS-1$
			" FROM SYS.SYSTABLES A,SYS.SYSSCHEMAS B"+ //$NON-NLS-1$
			" WHERE A.SCHEMAID=B.SCHEMAID" + //$NON-NLS-1$
			" AND TABLETYPE='A'"; //$NON-NLS-1$ //$NON-NLS-2$

			Statement s = connection.createStatement();
			ResultSet r = s.executeQuery(query);
			
			while (r.next()) {
				final String tableName = r.getString("TABLENAME"); //$NON-NLS-1$
				this.setTable(this.getTable(this.getSchema().getName(), tableName));
				
				this.aliasedTableLoaded = true;
			}
			r.close();
			s.close();
		}
		catch (Exception e) {
		}
		
		this.eSetDeliver(deliver);
	}
	
	private boolean aliasedTableLoaded = false;
	private boolean columnsLoaded=false;
}
