/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.connectivity.internal.derby.containment;

import org.eclipse.datatools.connectivity.sqm.core.containment.AbstractContainmentProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.datatools.modelbase.derby.Synonym;
import org.eclipse.datatools.modelbase.derby.DerbyModelPackage;


public class DerbySynonymContainmentProvider  extends AbstractContainmentProvider {
	public EObject getContainer(EObject obj) {
		return ((Synonym) obj).getSchema();
	}

	public EStructuralFeature getContainmentFeature(EObject obj) {
		return DerbyModelPackage.eINSTANCE.getSynonym_Table();
	}

	public String getGroupId(EObject obj) {
		return DerbyGroupID.SYNONYM;
	}

}
