/*
* This program and the accompanying materials 
* are made available under the terms of the Eclipse Public License v1.0
* which is available at
* http://www.eclipse.org/legal/epl-v10.html
*/

package org.eclipse.datatools.sqltools.parsers.sql.xml.query;

public interface SQLXMLQueryParsersym {
    public final static int
      TK_ACCESS = 119,
      TK_ACCTNG = 120,
      TK_ACTION = 121,
      TK_ACTIVATE = 122,
      TK_ADD = 123,
      TK_ADMIN = 124,
      TK_ADMINISTRATION = 125,
      TK_AFTER = 126,
      TK_AGE = 127,
      TK_ALIAS = 128,
      TK_ALL = 20,
      TK_ALLOCATE = 129,
      TK_ALLOW = 130,
      TK_ALTER = 131,
      TK_ALTERIN = 132,
      TK_ALWAYS = 133,
      TK_AND = 29,
      TK_ANY = 51,
      TK_APPEND = 134,
      TK_APPL_ID = 135,
      TK_APPL_NAME = 136,
      TK_APPLNAME = 137,
      TK_ARRAY = 21,
      TK_AS = 3,
      TK_ASC = 52,
      TK_ASCII = 138,
      TK_ASENSITIVE = 139,
      TK_ASSIGNMENT = 140,
      TK_ASSOCIATE = 141,
      TK_AST = 142,
      TK_ASUTIME = 143,
      TK_AT = 144,
      TK_ATOMIC = 145,
      TK_ATTRIBUTE = 146,
      TK_ATTRIBUTES = 147,
      TK_AUTHORIZATION = 148,
      TK_AUTH_ID = 149,
      TK_AUTHID = 150,
      TK_AUTOMATIC = 151,
      TK_AUTOSTART = 152,
      TK_AVAILABLE = 153,
      TK_B = 154,
      TK_BEFORE = 155,
      TK_BEGIN = 156,
      TK_BERNOULLI = 157,
      TK_BETWEEN = 22,
      TK_BIGINT = 158,
      TK_BINARY = 159,
      TK_BIND = 160,
      TK_BINDADD = 161,
      TK_BIT = 162,
      TK_BLOB = 163,
      TK_BLOCKED = 164,
      TK_BLOCKSIZE = 165,
      TK_BOTH = 166,
      TK_BUFFER = 167,
      TK_BUFFERPOOL = 168,
      TK_BUFFERPOOLS = 169,
      TK_BUFFERSIZE = 170,
      TK_BUILD = 171,
      TK_BY = 7,
      TK_BYPASS = 172,
      TK_C = 173,
      TK_CACHE = 174,
      TK_CACHING = 175,
      TK_CALL = 176,
      TK_CALLED = 177,
      TK_CALLER = 178,
      TK_CAPTURE = 179,
      TK_CARDINALITIES = 180,
      TK_CARDINALITY = 181,
      TK_CASCADE = 182,
      TK_CASCADED = 183,
      TK_CASE = 184,
      TK_CAST = 185,
      TK_CCSID = 186,
      TK_CHANGE = 187,
      TK_CHANGED = 188,
      TK_CHANGES = 189,
      TK_CHAR = 190,
      TK_CHARACTER = 191,
      TK_CHECK = 192,
      TK_CHECKED = 193,
      TK_CLIENT = 194,
      TK_CLIENT_ACCTNG = 195,
      TK_CLIENT_APPLNAME = 196,
      TK_CLIENT_USERID = 197,
      TK_CLIENT_WRKSTNNAME = 198,
      TK_CLOB = 199,
      TK_CLOSE = 200,
      TK_CLR = 201,
      TK_CLUSTER = 202,
      TK_COBOL = 203,
      TK_COLLECT = 204,
      TK_COLLID = 205,
      TK_COLUMN = 206,
      TK_COLUMNS = 53,
      TK_COMM = 207,
      TK_COMMENT = 208,
      TK_COMMIT = 209,
      TK_COMMITTED = 210,
      TK_COMPACT = 211,
      TK_COMPARE = 212,
      TK_COMPARISONS = 213,
      TK_COMPRESS = 214,
      TK_COMPRESSION = 215,
      TK_CONCAT = 54,
      TK_CONDITION = 216,
      TK_CONN = 217,
      TK_CONNECT = 218,
      TK_CONNECTIONS = 219,
      TK_CONNECTOPT = 220,
      TK_CONNHEADER = 221,
      TK_CONNMEMUSE = 222,
      TK_CONSERVATIVE = 223,
      TK_CONSTRAINT = 224,
      TK_CONSTRAINTS = 225,
      TK_CONSTRUCTOR = 226,
      TK_CONTAINERS = 227,
      TK_CONTAINS = 228,
      TK_CONTENT = 8,
      TK_CONTINUE = 229,
      TK_CONTINUOUSLY = 230,
      TK_CONTROL = 231,
      TK_COPY = 232,
      TK_COUNT = 233,
      TK_COUNT_BIG = 234,
      TK_CPU = 235,
      TK_CREATE = 236,
      TK_CREATE_EXTERNAL_ROUTINE = 237,
      TK_CREATEIN = 238,
      TK_CREATE_NOT_FENCED = 239,
      TK_CREATE_NOT_FENCED_ROUTINE = 240,
      TK_CREATETAB = 241,
      TK_CS = 242,
      TK_CUBE = 55,
      TK_CURRENT = 243,
      TK_CURRENT_DATE = 244,
      TK_CURRENT_DEFAULT_TRANSFORM_GROUP = 245,
      TK_CURRENT_PATH = 56,
      TK_CURRENT_ROLE = 57,
      TK_CURRENT_SCHEMA = 246,
      TK_CURRENT_SERVER = 247,
      TK_CURRENT_TIME = 248,
      TK_CURRENT_TIMESTAMP = 249,
      TK_CURRENT_TIMEZONE = 250,
      TK_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 251,
      TK_CURRENT_USER = 58,
      TK_CURRVAL = 252,
      TK_CURSOR = 253,
      TK_CURSORS = 254,
      TK_CYCLE = 255,
      TK_DATA = 256,
      TK_DATABASE = 257,
      TK_DATALINK = 258,
      TK_DATE = 259,
      TK_DAY = 260,
      TK_DAYS = 59,
      TK_DB = 261,
      TK_DBADM = 262,
      TK_DBCLOB = 263,
      TK_DBINFO = 264,
      TK_DBMEMUSE = 265,
      TK_DBPARTITIONNUM = 266,
      TK_DBPARTITIONNUMS = 267,
      TK_DB2DARI = 268,
      TK_DB2GENRL = 269,
      TK_DB2GENERAL = 270,
      TK_DB2OPTIONS = 271,
      TK_DB2SPL = 272,
      TK_DB2SQL = 273,
      TK_DB2_RETURN_STATUS = 274,
      TK_DB2_TOKEN_STRING = 275,
      TK_DEACTIVATE = 276,
      TK_DEADLOCK = 277,
      TK_DEADLOCKS = 278,
      TK_DEC = 279,
      TK_DECIMAL = 280,
      TK_DECLARE = 281,
      TK_DEFAULT = 30,
      TK_DEFAULTS = 282,
      TK_DEFINE = 283,
      TK_DEFINITION = 284,
      TK_DEGREE = 285,
      TK_DEFER = 286,
      TK_DEFERRED = 287,
      TK_DELETE = 60,
      TK_DESC = 61,
      TK_DESCRIPTOR = 288,
      TK_DETAILED = 289,
      TK_DETAILS = 290,
      TK_DETERMINED = 291,
      TK_DETERMINISTIC = 292,
      TK_DEVICE = 293,
      TK_DIAGNOSTICS = 294,
      TK_DIMENSIONS = 295,
      TK_DIRTY = 296,
      TK_DISABLE = 297,
      TK_DISALLOW = 298,
      TK_DISPATCH = 299,
      TK_DISTINCT = 31,
      TK_DISTRIBUTION = 300,
      TK_DLCONN = 301,
      TK_DLLOCK = 302,
      TK_DO = 303,
      TK_DOUBLE = 304,
      TK_DROP = 305,
      TK_DROPIN = 306,
      TK_DROPPED = 307,
      TK_DYNAMIC = 308,
      TK_EACH = 309,
      TK_ELEMENT = 32,
      TK_ELSE = 62,
      TK_ELSEIF = 310,
      TK_EMPTY = 23,
      TK_ENABLE = 311,
      TK_ENCRYPTION = 312,
      TK_END = 63,
      TK_ENDING = 313,
      TK_ENFORCED = 314,
      TK_ERASE = 315,
      TK_ESCAPE = 64,
      TK_ESTIMATE = 316,
      TK_EUR = 317,
      TK_EVALUATE = 318,
      TK_EVENT = 319,
      TK_EXACT = 320,
      TK_EXCEPT = 9,
      TK_EXCEPTION = 321,
      TK_EXCLUDE = 322,
      TK_EXCLUDES = 323,
      TK_EXCLUDING = 65,
      TK_EXCLUSIVE = 324,
      TK_EXECNODE = 325,
      TK_EXECUTE = 326,
      TK_EXISTS = 327,
      TK_EXIT = 328,
      TK_EXPAND = 329,
      TK_EXPLAIN = 330,
      TK_EXPRESSION = 331,
      TK_EXTEND = 332,
      TK_EXTENDED = 333,
      TK_EXTENSION = 334,
      TK_EXTENTSIZE = 335,
      TK_EXTERNAL = 336,
      TK_FALSE = 33,
      TK_FEDERATED = 337,
      TK_FEDERATED_TOOL = 338,
      TK_FENCED = 339,
      TK_FETCH = 340,
      TK_FILE = 341,
      TK_FILTER = 342,
      TK_FINAL = 343,
      TK_FIRST = 66,
      TK_FLOAT = 344,
      TK_FLUSH = 345,
      TK_FOLLOWING = 346,
      TK_FOR = 347,
      TK_FORCE = 348,
      TK_FOREIGN = 349,
      TK__FOREIGNKEY = 350,
      TK_FOUND = 351,
      TK_FREE = 352,
      TK_FREEPAGE = 353,
      TK_FROM = 24,
      TK_FS = 354,
      TK_FULL = 10,
      TK_FUNCTION = 355,
      TK_G = 34,
      TK_GBPCACHE = 356,
      TK_GENERAL = 357,
      TK_GENERATE = 358,
      TK_GENERATED = 359,
      TK_GET = 360,
      TK_GLOBAL = 361,
      TK_GOTO = 362,
      TK_GRANT = 363,
      TK_GRAPHIC = 364,
      TK_GROUP = 35,
      TK_GROUPING = 365,
      TK_HANDLER = 366,
      TK_HASHING = 367,
      TK_HAVING = 36,
      TK_HIDDEN = 368,
      TK_HIERARCHY = 369,
      TK_HIGH = 370,
      TK_HOLD = 371,
      TK_HOUR = 372,
      TK_HOURS = 67,
      TK_HPJ = 373,
      TK_ID = 68,
      TK_IDENTITY = 374,
      TK_IF = 375,
      TK_IGNORE = 376,
      TK_IMMEDIATE = 377,
      TK_IMPLICIT_SCHEMA = 378,
      TK_IN = 4,
      TK_INCLUDE = 379,
      TK_INCLUDES = 380,
      TK_INCLUDING = 69,
      TK_INCREMENT = 381,
      TK_INCREMENTAL = 382,
      TK_INDEX = 383,
      TK_INDEXES = 384,
      TK_INDICATOR = 385,
      TK_INFIX = 386,
      TK_INFO = 387,
      TK_INHERIT = 388,
      TK_INITIALLY = 389,
      TK_INITIAL_INSTS = 390,
      TK_INITIAL_IOS = 391,
      TK_INLINE = 392,
      TK_INNER = 11,
      TK_INOUT = 393,
      TK_INPUT = 394,
      TK_INSENSITIVE = 395,
      TK_INSERT = 70,
      TK_INSTANTIABLE = 396,
      TK_INSTEAD = 397,
      TK_INSTS_PER_ARGBYTE = 398,
      TK_INSTS_PER_INVOC = 399,
      TK_INT = 400,
      TK_INTEGER = 401,
      TK_INTEGRITY = 402,
      TK_INTERSECT = 12,
      TK_INTO = 71,
      TK_IO = 403,
      TK_IOS_PER_ARGBYTE = 404,
      TK_IOS_PER_INVOC = 405,
      TK_IS = 25,
      TK_ISO = 406,
      TK_ITERATE = 407,
      TK_ISOLATION = 408,
      TK_JAVA = 409,
      TK_JIS = 410,
      TK_JOIN = 37,
      TK_K = 72,
      TK_KEEP = 411,
      TK_KEY = 412,
      TK_KEYS = 413,
      TK_L = 414,
      TK_LANGUAGE = 415,
      TK_LARGE = 73,
      TK_LAST = 74,
      TK_LATERAL = 416,
      TK_LC_CTYPE = 417,
      TK_LEADING = 418,
      TK_LEAVE = 419,
      TK_LEFT = 13,
      TK_LENGTH = 420,
      TK_LEVEL = 421,
      TK_LEVEL2 = 422,
      TK_LIBRARY = 423,
      TK_LIBRARYADM = 424,
      TK_LIKE = 26,
      TK_LIMIT = 425,
      TK_LINK = 426,
      TK_LINKTYPE = 427,
      TK_LOAD = 428,
      TK_LOCAL = 429,
      TK_LOCALE = 430,
      TK_LOCALTIME = 431,
      TK_LOCALTIMESTAMP = 432,
      TK_LOCATOR = 433,
      TK_LOCATORS = 434,
      TK_LOCK = 435,
      TK_LOCKS = 436,
      TK_LOCKSIZE = 437,
      TK_LOG = 438,
      TK_LOGGED = 439,
      TK_LONG = 440,
      TK_LONGVAR = 441,
      TK_LOOP = 442,
      TK_LOW = 443,
      TK_M = 75,
      TK_MAINTAINED = 444,
      TK_MAIN_PROG = 445,
      TK_MANAGED = 446,
      TK_MANUALSTART = 447,
      TK_MAPPING = 448,
      TK_MATCHED = 449,
      TK_MATERIALIZED = 450,
      TK_MAXFILES = 451,
      TK_MAXFILESIZE = 452,
      TK_MAXVALUE = 453,
      TK_MDC = 454,
      TK_MERGE = 455,
      TK_MESSAGE_TEXT = 456,
      TK_METHOD = 457,
      TK_METHODS = 458,
      TK_MICROSECOND = 459,
      TK_MICROSECONDS = 76,
      TK_MINPCTUSED = 460,
      TK_MINUTE = 461,
      TK_MINUTES = 77,
      TK_MINVALUE = 462,
      TK_MIXED = 463,
      TK_MODE = 464,
      TK_MODIFIES = 465,
      TK_MONITOR = 466,
      TK_MONTH = 467,
      TK_MONTHS = 78,
      TK_MOVEMENT = 468,
      TK_MULTISET = 27,
      TK_N = 79,
      TK_NAME = 80,
      TK_NEW = 469,
      TK_NEW_TABLE = 470,
      TK_NEXT = 471,
      TK_NEXTVAL = 472,
      TK_NICKNAME = 473,
      TK_NO = 14,
      TK_NOCACHE = 474,
      TK_NOCYCLE = 475,
      TK_NODE = 476,
      TK_NODES = 477,
      TK_NODEGROUP = 478,
      TK_NOMAXVALUE = 479,
      TK_NOMINVALUE = 480,
      TK_NONBLOCKED = 481,
      TK_NONE = 482,
      TK_NOORDER = 483,
      TK_NOT = 5,
      TK_NULL = 6,
      TK_NULLS = 81,
      TK_NUM = 484,
      TK_NUMBLOCKPAGES = 485,
      TK_NUMERIC = 486,
      TK_NUM_FREQVALUES = 487,
      TK_NUM_QUANTILES = 488,
      TK_OBJECT = 82,
      TK_OF = 489,
      TK_OFF = 490,
      TK_OLD = 491,
      TK_OLD_TABLE = 492,
      TK_OLE = 493,
      TK_OLEDB = 494,
      TK_ON = 28,
      TK_ONCE = 495,
      TK_ONLINE = 496,
      TK_ONLY = 497,
      TK_OPEN = 498,
      TK_OPTIMIZATION = 499,
      TK_OPTIMIZE = 500,
      TK_OPTION = 83,
      TK_OPTIONS = 501,
      TK_OR = 38,
      TK_ORDER = 39,
      TK_ORGANIZE = 502,
      TK_OUT = 503,
      TK_OUTER = 84,
      TK_OVER = 504,
      TK_OVERFLOW = 505,
      TK_OVERHEAD = 506,
      TK_OVERRIDING = 507,
      TK_P = 508,
      TK_PACKAGE = 509,
      TK_PAGE = 510,
      TK_PAGESIZE = 511,
      TK_PARALLEL = 512,
      TK_PARAMETER = 513,
      TK_PASSTHRU = 514,
      TK_PASSWORD = 515,
      TK_PATH = 85,
      TK_PARTITION = 516,
      TK_PARTITIONING = 517,
      TK_PARTITIONINGS = 518,
      TK_PATROLLER = 519,
      TK_PCTDEACTIVATE = 520,
      TK_PCTFREE = 521,
      TK_PENDING = 522,
      TK_PERCENT_ARGBYTES = 523,
      TK_PERMISSION = 524,
      TK_PIECESIZE = 525,
      TK_PIPE = 526,
      TK_PLAN = 527,
      TK_PRECEDING = 528,
      TK_PRECISION = 86,
      TK_PREDICATES = 529,
      TK_PREFETCHSIZE = 530,
      TK_PREPARE = 531,
      TK_PRESERVE = 87,
      TK_PREVIOUS = 532,
      TK_PREVVAL = 533,
      TK_PRIMARY = 534,
      TK__PRIMARYKEY = 535,
      TK_PRIQTY = 536,
      TK_PRIVILEGES = 537,
      TK_PROCEDURE = 538,
      TK_PROFILE = 539,
      TK_PROGRAM = 540,
      TK_PROPAGATE = 541,
      TK_PROTOCOL = 542,
      TK_PRUNE = 543,
      TK_PUBLIC = 544,
      TK_QUERY = 545,
      TK_QUERYNO = 546,
      TK_QUERYTAG = 547,
      TK_QUIESCE_CONNECT = 548,
      TK_RANGE = 549,
      TK_RATE = 550,
      TK_RATIO = 551,
      TK_READ = 552,
      TK_READS = 553,
      TK_REAL = 554,
      TK_RECOMMEND = 555,
      TK_RECONCILE = 556,
      TK_RECOVERY = 557,
      TK_RECREATE = 558,
      TK_REDUCE = 559,
      TK_REF = 88,
      TK_REFERENCE = 560,
      TK_REFERENCES = 561,
      TK_REFERENCING = 562,
      TK_REFRESH = 563,
      TK_REGISTERS = 564,
      TK_REGULAR = 565,
      TK_RELEASE = 566,
      TK_REMAIN = 567,
      TK_REMOTE = 568,
      TK_RENAME = 569,
      TK_REOPT = 570,
      TK_REPEATABLE = 571,
      TK_REPEAT = 572,
      TK_REPLACE = 573,
      TK_REPLICATED = 574,
      TK_REQUIRING = 575,
      TK_RESET = 576,
      TK_RESIDENT = 577,
      TK_RESIGNAL = 578,
      TK_RESIZE = 579,
      TK_RESOLVE = 580,
      TK_RESTART = 581,
      TK_RESTORE = 582,
      TK_RESTRICT = 583,
      TK_RESULT = 584,
      TK_RESULT_SET_LOCATOR = 585,
      TK_RETAIN = 586,
      TK_RETURN = 587,
      TK_RETURNS = 588,
      TK_RETURN_STATUS = 589,
      TK_REVERSE = 590,
      TK_REVOKE = 591,
      TK_RIGHT = 15,
      TK_ROLLBACK = 592,
      TK_ROLLUP = 89,
      TK_ROUTINE = 593,
      TK_ROW = 594,
      TK_ROW_COUNT = 595,
      TK_ROWS = 596,
      TK_RR = 597,
      TK_RS = 598,
      TK_RUN = 599,
      TK_S = 600,
      TK_SAMPLED = 601,
      TK_SAVEPOINT = 602,
      TK_SBCS = 603,
      TK_SCANS = 604,
      TK_SCHEMA = 605,
      TK_SCOPE = 606,
      TK_SCRATCHPAD = 607,
      TK_SCROLL = 608,
      TK_SEARCH = 609,
      TK_SECOND = 610,
      TK_SECONDS = 90,
      TK_SECQTY = 611,
      TK_SECURITYADM = 612,
      TK_SELECT = 91,
      TK_SELECTION = 613,
      TK_SELECTIVE = 614,
      TK_SELECTIVITY = 615,
      TK_SELF = 616,
      TK_SENSITIVE = 617,
      TK_SEQUENCE = 40,
      TK_SERIALIZABLE = 618,
      TK_SERVER = 619,
      TK_SESSION = 620,
      TK_SESSION_USER = 92,
      TK_SET = 41,
      TK_SETS = 93,
      TK_SETTING = 621,
      TK_SHARE = 622,
      TK_SHRLEVEL = 623,
      TK_SIGNAL = 624,
      TK_SIMPLE = 625,
      TK_SIZE = 626,
      TK_SMALLINT = 627,
      TK_SNAPSHOT = 628,
      TK_SOME = 94,
      TK_SOURCE = 629,
      TK_SPECIAL = 630,
      TK_SPECIFIC = 631,
      TK_SPECIFICATION = 632,
      TK_SPLIT = 633,
      TK_SQL = 634,
      TK_SQLDATA = 635,
      TK_SQLERROR = 636,
      TK_SQLEXCEPTION = 637,
      TK_SQLWARNING = 638,
      TK_SQLID = 639,
      TK_SQLMACRO = 640,
      TK_SQLSTATE = 641,
      TK_SSA = 642,
      TK_STABILITY = 643,
      TK_STAGING = 644,
      TK_START = 645,
      TK_STATE = 646,
      TK_STATEMENT = 647,
      TK_STATEMENTS = 648,
      TK_STATIC = 649,
      TK_STATISTICS = 650,
      TK_STARTING = 651,
      TK_STAY = 652,
      TK_STMT = 653,
      TK_STOGROUP = 654,
      TK_STORAGE = 655,
      TK_STORED = 656,
      TK_STRIP = 95,
      TK_STRIPE = 657,
      TK_STYLE = 658,
      TK_SUB = 659,
      TK_SUBSECTION = 660,
      TK_SUMMARY = 661,
      TK_SWITCH = 662,
      TK_SYMMETRIC = 663,
      TK_SYNONYM = 664,
      TK_SYSTEM = 665,
      TK_SYSTEM_USER = 96,
      TK_T = 666,
      TK_TABLE = 667,
      TK_TABLES = 668,
      TK_TABLESAMPLE = 669,
      TK_TABLESPACE = 670,
      TK_TABLESPACES = 671,
      TK_TARGET = 672,
      TK_TEMPLATE = 673,
      TK_TEMPORARY = 674,
      TK_THEN = 42,
      TK_THREADSAFE = 675,
      TK_THROUGH = 676,
      TK_TIME = 677,
      TK_TIMEOUT = 678,
      TK_TIMESTAMP = 679,
      TK_TIMEZONE = 680,
      TK_TO = 97,
      TK_TOKEN = 681,
      TK_TRAILING = 682,
      TK_TRANSACTIONS = 683,
      TK_TRANSFERRATE = 684,
      TK_TRANSFORM = 685,
      TK_TRANSFORMS = 686,
      TK_TRANSLATE = 687,
      TK_TREAT = 688,
      TK_TRIGGER = 689,
      TK_TRUE = 43,
      TK_TRUNC = 690,
      TK_TWOLEVEL = 691,
      TK_TYPE = 692,
      TK_TYPES = 693,
      TK_UNBOUNDED = 694,
      TK_UNCHECKED = 695,
      TK_UNCOMMITTED = 696,
      TK_UNDER = 697,
      TK_UNDO = 698,
      TK_UNICODE = 699,
      TK_UNION = 16,
      TK_UNIQUE = 700,
      TK_UNLINK = 701,
      TK_UNTIL = 702,
      TK_UPDATE = 98,
      TK_UR = 703,
      TK_URL = 704,
      TK_USA = 705,
      TK_USE = 706,
      TK_USAGE = 707,
      TK_USER = 99,
      TK_USERID = 708,
      TK_USING = 709,
      TK_VALUE = 100,
      TK_VALUES = 44,
      TK_VARCHAR = 710,
      TK_VARGRAPHIC = 711,
      TK_VARIANT = 712,
      TK_VARYING = 101,
      TK_VCAT = 713,
      TK_VERSION = 102,
      TK_VIEW = 714,
      TK_VOLATILE = 715,
      TK_WAIT = 716,
      TK_WHEN = 45,
      TK_WHERE = 17,
      TK_WHILE = 717,
      TK_WITH = 18,
      TK_WITHOUT = 718,
      TK_WORK = 719,
      TK_WRAPPER = 720,
      TK_WRITE = 721,
      TK_WRKSTNNAME = 722,
      TK_X = 103,
      TK_XACT = 723,
      TK_YEAR = 724,
      TK_YEARS = 104,
      TK_YES = 725,
      TK_ABSENT = 105,
      TK_ACCORDING = 106,
      TK_BASE64 = 726,
      TK_DOCUMENT = 46,
      TK_ENCODING = 107,
      TK_HEX = 727,
      TK_LOCATION = 108,
      TK_NAMESPACE = 47,
      TK_NIL = 109,
      TK_ORDINALITY = 110,
      TK_PASSING = 111,
      TK_PI = 728,
      TK_RETURNING = 48,
      TK_URI = 112,
      TK_WHITESPACE = 113,
      TK_XML = 729,
      TK_XMLAGG = 730,
      TK_XMLATTRIBUTES = 114,
      TK_XMLBINARY = 731,
      TK_XMLCAST = 732,
      TK_XMLCOMMENT = 733,
      TK_XMLCONCAT = 734,
      TK_XMLDECLARATION = 115,
      TK_XMLDOCUMENT = 735,
      TK_XMLELEMENT = 736,
      TK_XMLEXISTS = 737,
      TK_XMLFOREST = 738,
      TK_XMLNAMESPACES = 116,
      TK_XMLPARSE = 739,
      TK_XMLPI = 740,
      TK_XMLQUERY = 741,
      TK_XMLSCHEMA = 117,
      TK_XMLSERIALIZE = 742,
      TK_XMLTABLE = 743,
      TK_XMLTEXT = 744,
      TK_XMLVALIDATE = 745,
      TK_DOUBLE_QUOTE = 768,
      TK_QUOTE = 769,
      TK_LEFT_PAREN = 49,
      TK_RIGHT_PAREN = 19,
      TK_ASTERISK = 749,
      TK_PLUS_SIGN = 1,
      TK_COMMA = 50,
      TK_MINUS_SIGN = 2,
      TK_PERIOD = 760,
      TK_SOLIDUS = 761,
      TK_COLON = 770,
      TK_SEMICOLON = 771,
      TK_LESS_THAN_OPERATOR = 755,
      TK_EQUALS_OPERATOR = 752,
      TK_GREATER_THAN_OPERATOR = 756,
      TK_QUESTION_MARK = 772,
      TK_LEFT_BRACKET = 762,
      TK_RIGHT_BRACKET = 763,
      TK_VERTICAL_BAR = 773,
      TK_NOT_EQUALS_OPERATOR = 757,
      TK_GREATER_THAN_OR_EQUALS_OPERATOR = 758,
      TK_LESS_THAN_OR_EQUALS_OPERATOR = 759,
      TK_CONCAT_OPERATOR = 764,
      TK_DOUBLE_PERIOD = 774,
      TK_RIGHT_ARROW = 775,
      TK_REGULAR_IDENTIFIER = 746,
      TK_DELIMITED_IDENTIFIER = 747,
      TK_EMBEDDED_VARIABLE_NAME = 776,
      TK_UNSIGNED_INTEGER = 748,
      TK_SUFFIXED_UNSIGNED_INTEGER = 777,
      TK_EXACT_NUMERIC_LITERAL = 750,
      TK_APPROXIMATE_NUMERIC_LITERAL = 751,
      TK_NATIONAL_CHAR_STRING_LITERAL = 778,
      TK_NATIONAL_HEX_STRING_LITERAL = 779,
      TK_BIT_STRING_LITERAL = 780,
      TK_HEX_STRING_LITERAL = 781,
      TK_CHAR_STRING_LITERAL = 118,
      TK_COMMENT_STRING = 782,
      TK_DELIMITED_TYPE_IDENTIFIER = 783,
      TK_VERSION_IDENTIFIER = 784,
      TK_STATEMENT_TERMINATOR = 765,
      TK_HOSTVARIABLE = 753,
      TK_PARAMETER_MARKER = 754,
      TK_LEFT_BRACKET_TRIGRAPH = 766,
      TK_RIGHT_BRACKET_TRIGRAPH = 767,
      TK_EOLN = 785,
      TK_EOF = 786,
      TK_PARSE_ERROR = 787;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "PLUS_SIGN",
                 "MINUS_SIGN",
                 "AS",
                 "IN",
                 "NOT",
                 "NULL",
                 "BY",
                 "CONTENT",
                 "EXCEPT",
                 "FULL",
                 "INNER",
                 "INTERSECT",
                 "LEFT",
                 "NO",
                 "RIGHT",
                 "UNION",
                 "WHERE",
                 "WITH",
                 "RIGHT_PAREN",
                 "ALL",
                 "ARRAY",
                 "BETWEEN",
                 "EMPTY",
                 "FROM",
                 "IS",
                 "LIKE",
                 "MULTISET",
                 "ON",
                 "AND",
                 "DEFAULT",
                 "DISTINCT",
                 "ELEMENT",
                 "FALSE",
                 "G",
                 "GROUP",
                 "HAVING",
                 "JOIN",
                 "OR",
                 "ORDER",
                 "SEQUENCE",
                 "SET",
                 "THEN",
                 "TRUE",
                 "VALUES",
                 "WHEN",
                 "DOCUMENT",
                 "NAMESPACE",
                 "RETURNING",
                 "LEFT_PAREN",
                 "COMMA",
                 "ANY",
                 "ASC",
                 "COLUMNS",
                 "CONCAT",
                 "CUBE",
                 "CURRENT_PATH",
                 "CURRENT_ROLE",
                 "CURRENT_USER",
                 "DAYS",
                 "DELETE",
                 "DESC",
                 "ELSE",
                 "END",
                 "ESCAPE",
                 "EXCLUDING",
                 "FIRST",
                 "HOURS",
                 "ID",
                 "INCLUDING",
                 "INSERT",
                 "INTO",
                 "K",
                 "LARGE",
                 "LAST",
                 "M",
                 "MICROSECONDS",
                 "MINUTES",
                 "MONTHS",
                 "N",
                 "NAME",
                 "NULLS",
                 "OBJECT",
                 "OPTION",
                 "OUTER",
                 "PATH",
                 "PRECISION",
                 "PRESERVE",
                 "REF",
                 "ROLLUP",
                 "SECONDS",
                 "SELECT",
                 "SESSION_USER",
                 "SETS",
                 "SOME",
                 "STRIP",
                 "SYSTEM_USER",
                 "TO",
                 "UPDATE",
                 "USER",
                 "VALUE",
                 "VARYING",
                 "VERSION",
                 "X",
                 "YEARS",
                 "ABSENT",
                 "ACCORDING",
                 "ENCODING",
                 "LOCATION",
                 "NIL",
                 "ORDINALITY",
                 "PASSING",
                 "URI",
                 "WHITESPACE",
                 "XMLATTRIBUTES",
                 "XMLDECLARATION",
                 "XMLNAMESPACES",
                 "XMLSCHEMA",
                 "CHAR_STRING_LITERAL",
                 "ACCESS",
                 "ACCTNG",
                 "ACTION",
                 "ACTIVATE",
                 "ADD",
                 "ADMIN",
                 "ADMINISTRATION",
                 "AFTER",
                 "AGE",
                 "ALIAS",
                 "ALLOCATE",
                 "ALLOW",
                 "ALTER",
                 "ALTERIN",
                 "ALWAYS",
                 "APPEND",
                 "APPL_ID",
                 "APPL_NAME",
                 "APPLNAME",
                 "ASCII",
                 "ASENSITIVE",
                 "ASSIGNMENT",
                 "ASSOCIATE",
                 "AST",
                 "ASUTIME",
                 "AT",
                 "ATOMIC",
                 "ATTRIBUTE",
                 "ATTRIBUTES",
                 "AUTHORIZATION",
                 "AUTH_ID",
                 "AUTHID",
                 "AUTOMATIC",
                 "AUTOSTART",
                 "AVAILABLE",
                 "B",
                 "BEFORE",
                 "BEGIN",
                 "BERNOULLI",
                 "BIGINT",
                 "BINARY",
                 "BIND",
                 "BINDADD",
                 "BIT",
                 "BLOB",
                 "BLOCKED",
                 "BLOCKSIZE",
                 "BOTH",
                 "BUFFER",
                 "BUFFERPOOL",
                 "BUFFERPOOLS",
                 "BUFFERSIZE",
                 "BUILD",
                 "BYPASS",
                 "C",
                 "CACHE",
                 "CACHING",
                 "CALL",
                 "CALLED",
                 "CALLER",
                 "CAPTURE",
                 "CARDINALITIES",
                 "CARDINALITY",
                 "CASCADE",
                 "CASCADED",
                 "CASE",
                 "CAST",
                 "CCSID",
                 "CHANGE",
                 "CHANGED",
                 "CHANGES",
                 "CHAR",
                 "CHARACTER",
                 "CHECK",
                 "CHECKED",
                 "CLIENT",
                 "CLIENT_ACCTNG",
                 "CLIENT_APPLNAME",
                 "CLIENT_USERID",
                 "CLIENT_WRKSTNNAME",
                 "CLOB",
                 "CLOSE",
                 "CLR",
                 "CLUSTER",
                 "COBOL",
                 "COLLECT",
                 "COLLID",
                 "COLUMN",
                 "COMM",
                 "COMMENT",
                 "COMMIT",
                 "COMMITTED",
                 "COMPACT",
                 "COMPARE",
                 "COMPARISONS",
                 "COMPRESS",
                 "COMPRESSION",
                 "CONDITION",
                 "CONN",
                 "CONNECT",
                 "CONNECTIONS",
                 "CONNECTOPT",
                 "CONNHEADER",
                 "CONNMEMUSE",
                 "CONSERVATIVE",
                 "CONSTRAINT",
                 "CONSTRAINTS",
                 "CONSTRUCTOR",
                 "CONTAINERS",
                 "CONTAINS",
                 "CONTINUE",
                 "CONTINUOUSLY",
                 "CONTROL",
                 "COPY",
                 "COUNT",
                 "COUNT_BIG",
                 "CPU",
                 "CREATE",
                 "CREATE_EXTERNAL_ROUTINE",
                 "CREATEIN",
                 "CREATE_NOT_FENCED",
                 "CREATE_NOT_FENCED_ROUTINE",
                 "CREATETAB",
                 "CS",
                 "CURRENT",
                 "CURRENT_DATE",
                 "CURRENT_DEFAULT_TRANSFORM_GROUP",
                 "CURRENT_SCHEMA",
                 "CURRENT_SERVER",
                 "CURRENT_TIME",
                 "CURRENT_TIMESTAMP",
                 "CURRENT_TIMEZONE",
                 "CURRENT_TRANSFORM_GROUP_FOR_TYPE",
                 "CURRVAL",
                 "CURSOR",
                 "CURSORS",
                 "CYCLE",
                 "DATA",
                 "DATABASE",
                 "DATALINK",
                 "DATE",
                 "DAY",
                 "DB",
                 "DBADM",
                 "DBCLOB",
                 "DBINFO",
                 "DBMEMUSE",
                 "DBPARTITIONNUM",
                 "DBPARTITIONNUMS",
                 "DB2DARI",
                 "DB2GENRL",
                 "DB2GENERAL",
                 "DB2OPTIONS",
                 "DB2SPL",
                 "DB2SQL",
                 "DB2_RETURN_STATUS",
                 "DB2_TOKEN_STRING",
                 "DEACTIVATE",
                 "DEADLOCK",
                 "DEADLOCKS",
                 "DEC",
                 "DECIMAL",
                 "DECLARE",
                 "DEFAULTS",
                 "DEFINE",
                 "DEFINITION",
                 "DEGREE",
                 "DEFER",
                 "DEFERRED",
                 "DESCRIPTOR",
                 "DETAILED",
                 "DETAILS",
                 "DETERMINED",
                 "DETERMINISTIC",
                 "DEVICE",
                 "DIAGNOSTICS",
                 "DIMENSIONS",
                 "DIRTY",
                 "DISABLE",
                 "DISALLOW",
                 "DISPATCH",
                 "DISTRIBUTION",
                 "DLCONN",
                 "DLLOCK",
                 "DO",
                 "DOUBLE",
                 "DROP",
                 "DROPIN",
                 "DROPPED",
                 "DYNAMIC",
                 "EACH",
                 "ELSEIF",
                 "ENABLE",
                 "ENCRYPTION",
                 "ENDING",
                 "ENFORCED",
                 "ERASE",
                 "ESTIMATE",
                 "EUR",
                 "EVALUATE",
                 "EVENT",
                 "EXACT",
                 "EXCEPTION",
                 "EXCLUDE",
                 "EXCLUDES",
                 "EXCLUSIVE",
                 "EXECNODE",
                 "EXECUTE",
                 "EXISTS",
                 "EXIT",
                 "EXPAND",
                 "EXPLAIN",
                 "EXPRESSION",
                 "EXTEND",
                 "EXTENDED",
                 "EXTENSION",
                 "EXTENTSIZE",
                 "EXTERNAL",
                 "FEDERATED",
                 "FEDERATED_TOOL",
                 "FENCED",
                 "FETCH",
                 "FILE",
                 "FILTER",
                 "FINAL",
                 "FLOAT",
                 "FLUSH",
                 "FOLLOWING",
                 "FOR",
                 "FORCE",
                 "FOREIGN",
                 "_FOREIGNKEY",
                 "FOUND",
                 "FREE",
                 "FREEPAGE",
                 "FS",
                 "FUNCTION",
                 "GBPCACHE",
                 "GENERAL",
                 "GENERATE",
                 "GENERATED",
                 "GET",
                 "GLOBAL",
                 "GOTO",
                 "GRANT",
                 "GRAPHIC",
                 "GROUPING",
                 "HANDLER",
                 "HASHING",
                 "HIDDEN",
                 "HIERARCHY",
                 "HIGH",
                 "HOLD",
                 "HOUR",
                 "HPJ",
                 "IDENTITY",
                 "IF",
                 "IGNORE",
                 "IMMEDIATE",
                 "IMPLICIT_SCHEMA",
                 "INCLUDE",
                 "INCLUDES",
                 "INCREMENT",
                 "INCREMENTAL",
                 "INDEX",
                 "INDEXES",
                 "INDICATOR",
                 "INFIX",
                 "INFO",
                 "INHERIT",
                 "INITIALLY",
                 "INITIAL_INSTS",
                 "INITIAL_IOS",
                 "INLINE",
                 "INOUT",
                 "INPUT",
                 "INSENSITIVE",
                 "INSTANTIABLE",
                 "INSTEAD",
                 "INSTS_PER_ARGBYTE",
                 "INSTS_PER_INVOC",
                 "INT",
                 "INTEGER",
                 "INTEGRITY",
                 "IO",
                 "IOS_PER_ARGBYTE",
                 "IOS_PER_INVOC",
                 "ISO",
                 "ITERATE",
                 "ISOLATION",
                 "JAVA",
                 "JIS",
                 "KEEP",
                 "KEY",
                 "KEYS",
                 "L",
                 "LANGUAGE",
                 "LATERAL",
                 "LC_CTYPE",
                 "LEADING",
                 "LEAVE",
                 "LENGTH",
                 "LEVEL",
                 "LEVEL2",
                 "LIBRARY",
                 "LIBRARYADM",
                 "LIMIT",
                 "LINK",
                 "LINKTYPE",
                 "LOAD",
                 "LOCAL",
                 "LOCALE",
                 "LOCALTIME",
                 "LOCALTIMESTAMP",
                 "LOCATOR",
                 "LOCATORS",
                 "LOCK",
                 "LOCKS",
                 "LOCKSIZE",
                 "LOG",
                 "LOGGED",
                 "LONG",
                 "LONGVAR",
                 "LOOP",
                 "LOW",
                 "MAINTAINED",
                 "MAIN_PROG",
                 "MANAGED",
                 "MANUALSTART",
                 "MAPPING",
                 "MATCHED",
                 "MATERIALIZED",
                 "MAXFILES",
                 "MAXFILESIZE",
                 "MAXVALUE",
                 "MDC",
                 "MERGE",
                 "MESSAGE_TEXT",
                 "METHOD",
                 "METHODS",
                 "MICROSECOND",
                 "MINPCTUSED",
                 "MINUTE",
                 "MINVALUE",
                 "MIXED",
                 "MODE",
                 "MODIFIES",
                 "MONITOR",
                 "MONTH",
                 "MOVEMENT",
                 "NEW",
                 "NEW_TABLE",
                 "NEXT",
                 "NEXTVAL",
                 "NICKNAME",
                 "NOCACHE",
                 "NOCYCLE",
                 "NODE",
                 "NODES",
                 "NODEGROUP",
                 "NOMAXVALUE",
                 "NOMINVALUE",
                 "NONBLOCKED",
                 "NONE",
                 "NOORDER",
                 "NUM",
                 "NUMBLOCKPAGES",
                 "NUMERIC",
                 "NUM_FREQVALUES",
                 "NUM_QUANTILES",
                 "OF",
                 "OFF",
                 "OLD",
                 "OLD_TABLE",
                 "OLE",
                 "OLEDB",
                 "ONCE",
                 "ONLINE",
                 "ONLY",
                 "OPEN",
                 "OPTIMIZATION",
                 "OPTIMIZE",
                 "OPTIONS",
                 "ORGANIZE",
                 "OUT",
                 "OVER",
                 "OVERFLOW",
                 "OVERHEAD",
                 "OVERRIDING",
                 "P",
                 "PACKAGE",
                 "PAGE",
                 "PAGESIZE",
                 "PARALLEL",
                 "PARAMETER",
                 "PASSTHRU",
                 "PASSWORD",
                 "PARTITION",
                 "PARTITIONING",
                 "PARTITIONINGS",
                 "PATROLLER",
                 "PCTDEACTIVATE",
                 "PCTFREE",
                 "PENDING",
                 "PERCENT_ARGBYTES",
                 "PERMISSION",
                 "PIECESIZE",
                 "PIPE",
                 "PLAN",
                 "PRECEDING",
                 "PREDICATES",
                 "PREFETCHSIZE",
                 "PREPARE",
                 "PREVIOUS",
                 "PREVVAL",
                 "PRIMARY",
                 "_PRIMARYKEY",
                 "PRIQTY",
                 "PRIVILEGES",
                 "PROCEDURE",
                 "PROFILE",
                 "PROGRAM",
                 "PROPAGATE",
                 "PROTOCOL",
                 "PRUNE",
                 "PUBLIC",
                 "QUERY",
                 "QUERYNO",
                 "QUERYTAG",
                 "QUIESCE_CONNECT",
                 "RANGE",
                 "RATE",
                 "RATIO",
                 "READ",
                 "READS",
                 "REAL",
                 "RECOMMEND",
                 "RECONCILE",
                 "RECOVERY",
                 "RECREATE",
                 "REDUCE",
                 "REFERENCE",
                 "REFERENCES",
                 "REFERENCING",
                 "REFRESH",
                 "REGISTERS",
                 "REGULAR",
                 "RELEASE",
                 "REMAIN",
                 "REMOTE",
                 "RENAME",
                 "REOPT",
                 "REPEATABLE",
                 "REPEAT",
                 "REPLACE",
                 "REPLICATED",
                 "REQUIRING",
                 "RESET",
                 "RESIDENT",
                 "RESIGNAL",
                 "RESIZE",
                 "RESOLVE",
                 "RESTART",
                 "RESTORE",
                 "RESTRICT",
                 "RESULT",
                 "RESULT_SET_LOCATOR",
                 "RETAIN",
                 "RETURN",
                 "RETURNS",
                 "RETURN_STATUS",
                 "REVERSE",
                 "REVOKE",
                 "ROLLBACK",
                 "ROUTINE",
                 "ROW",
                 "ROW_COUNT",
                 "ROWS",
                 "RR",
                 "RS",
                 "RUN",
                 "S",
                 "SAMPLED",
                 "SAVEPOINT",
                 "SBCS",
                 "SCANS",
                 "SCHEMA",
                 "SCOPE",
                 "SCRATCHPAD",
                 "SCROLL",
                 "SEARCH",
                 "SECOND",
                 "SECQTY",
                 "SECURITYADM",
                 "SELECTION",
                 "SELECTIVE",
                 "SELECTIVITY",
                 "SELF",
                 "SENSITIVE",
                 "SERIALIZABLE",
                 "SERVER",
                 "SESSION",
                 "SETTING",
                 "SHARE",
                 "SHRLEVEL",
                 "SIGNAL",
                 "SIMPLE",
                 "SIZE",
                 "SMALLINT",
                 "SNAPSHOT",
                 "SOURCE",
                 "SPECIAL",
                 "SPECIFIC",
                 "SPECIFICATION",
                 "SPLIT",
                 "SQL",
                 "SQLDATA",
                 "SQLERROR",
                 "SQLEXCEPTION",
                 "SQLWARNING",
                 "SQLID",
                 "SQLMACRO",
                 "SQLSTATE",
                 "SSA",
                 "STABILITY",
                 "STAGING",
                 "START",
                 "STATE",
                 "STATEMENT",
                 "STATEMENTS",
                 "STATIC",
                 "STATISTICS",
                 "STARTING",
                 "STAY",
                 "STMT",
                 "STOGROUP",
                 "STORAGE",
                 "STORED",
                 "STRIPE",
                 "STYLE",
                 "SUB",
                 "SUBSECTION",
                 "SUMMARY",
                 "SWITCH",
                 "SYMMETRIC",
                 "SYNONYM",
                 "SYSTEM",
                 "T",
                 "TABLE",
                 "TABLES",
                 "TABLESAMPLE",
                 "TABLESPACE",
                 "TABLESPACES",
                 "TARGET",
                 "TEMPLATE",
                 "TEMPORARY",
                 "THREADSAFE",
                 "THROUGH",
                 "TIME",
                 "TIMEOUT",
                 "TIMESTAMP",
                 "TIMEZONE",
                 "TOKEN",
                 "TRAILING",
                 "TRANSACTIONS",
                 "TRANSFERRATE",
                 "TRANSFORM",
                 "TRANSFORMS",
                 "TRANSLATE",
                 "TREAT",
                 "TRIGGER",
                 "TRUNC",
                 "TWOLEVEL",
                 "TYPE",
                 "TYPES",
                 "UNBOUNDED",
                 "UNCHECKED",
                 "UNCOMMITTED",
                 "UNDER",
                 "UNDO",
                 "UNICODE",
                 "UNIQUE",
                 "UNLINK",
                 "UNTIL",
                 "UR",
                 "URL",
                 "USA",
                 "USE",
                 "USAGE",
                 "USERID",
                 "USING",
                 "VARCHAR",
                 "VARGRAPHIC",
                 "VARIANT",
                 "VCAT",
                 "VIEW",
                 "VOLATILE",
                 "WAIT",
                 "WHILE",
                 "WITHOUT",
                 "WORK",
                 "WRAPPER",
                 "WRITE",
                 "WRKSTNNAME",
                 "XACT",
                 "YEAR",
                 "YES",
                 "BASE64",
                 "HEX",
                 "PI",
                 "XML",
                 "XMLAGG",
                 "XMLBINARY",
                 "XMLCAST",
                 "XMLCOMMENT",
                 "XMLCONCAT",
                 "XMLDOCUMENT",
                 "XMLELEMENT",
                 "XMLEXISTS",
                 "XMLFOREST",
                 "XMLPARSE",
                 "XMLPI",
                 "XMLQUERY",
                 "XMLSERIALIZE",
                 "XMLTABLE",
                 "XMLTEXT",
                 "XMLVALIDATE",
                 "REGULAR_IDENTIFIER",
                 "DELIMITED_IDENTIFIER",
                 "UNSIGNED_INTEGER",
                 "ASTERISK",
                 "EXACT_NUMERIC_LITERAL",
                 "APPROXIMATE_NUMERIC_LITERAL",
                 "EQUALS_OPERATOR",
                 "HOSTVARIABLE",
                 "PARAMETER_MARKER",
                 "LESS_THAN_OPERATOR",
                 "GREATER_THAN_OPERATOR",
                 "NOT_EQUALS_OPERATOR",
                 "GREATER_THAN_OR_EQUALS_OPERATOR",
                 "LESS_THAN_OR_EQUALS_OPERATOR",
                 "PERIOD",
                 "SOLIDUS",
                 "LEFT_BRACKET",
                 "RIGHT_BRACKET",
                 "CONCAT_OPERATOR",
                 "STATEMENT_TERMINATOR",
                 "LEFT_BRACKET_TRIGRAPH",
                 "RIGHT_BRACKET_TRIGRAPH",
                 "DOUBLE_QUOTE",
                 "QUOTE",
                 "COLON",
                 "SEMICOLON",
                 "QUESTION_MARK",
                 "VERTICAL_BAR",
                 "DOUBLE_PERIOD",
                 "RIGHT_ARROW",
                 "EMBEDDED_VARIABLE_NAME",
                 "SUFFIXED_UNSIGNED_INTEGER",
                 "NATIONAL_CHAR_STRING_LITERAL",
                 "NATIONAL_HEX_STRING_LITERAL",
                 "BIT_STRING_LITERAL",
                 "HEX_STRING_LITERAL",
                 "COMMENT_STRING",
                 "DELIMITED_TYPE_IDENTIFIER",
                 "VERSION_IDENTIFIER",
                 "EOLN",
                 "EOF",
                 "PARSE_ERROR"
             };

    public final static boolean isValidForParser = true;
}
