/*******************************************************************************
 * Copyright (c) 2006 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: rcernich - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.connectivity.ui;

import java.net.URL;

import org.eclipse.datatools.connectivity.IConnectionProfileProvider;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class ProfileImageRegistry {

	private static final String IMG_OBJ_SERVER_DEFAULT = "org.eclipse.datatools.connectivity.ui.server_default_obj.gif"; //$NON-NLS-1$

	private static final String IMG_DESC_SERVER_DEFAULT = "icons/full/obj16/server_default_obj.gif"; //$NON-NLS-1$

	private static ProfileImageRegistry sInstance = new ProfileImageRegistry();

	private ImageRegistry mImageRegistry;

	public static ProfileImageRegistry getInstance() {
		return sInstance;
	}

	public Image getProfileImage(IConnectionProfileProvider provider) {
		Image image = mImageRegistry.get(provider.getId());
		if (image == null) {
			URL iconURL = provider.getIconURL();
			if (iconURL != null) {
				ImageDescriptor imageDesc = ImageDescriptor
						.createFromURL(iconURL);
				mImageRegistry.put(provider.getId(), imageDesc);
				image = mImageRegistry.get(provider.getId());
			}
			if (image == null) {
				image = mImageRegistry.get(IMG_OBJ_SERVER_DEFAULT);
			}
		}
		return image;
	}

	private ProfileImageRegistry() {
		mImageRegistry = new ImageRegistry();
		mImageRegistry.put(IMG_OBJ_SERVER_DEFAULT, ImageDescriptor
				.createFromURL(ConnectivityPlugin.getDefault().getBundle()
						.getEntry(IMG_DESC_SERVER_DEFAULT)));
	}
}
