/*******************************************************************************
 * Copyright (c) 2005 Sybase, Inc.
 * 
 * All rights reserved. This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License v1.0 which
 * accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: shongxum - initial API and implementation
 ******************************************************************************/
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.Iterator;
import java.util.Properties;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.PropertyPage;

/**
 * Base property page implementation for connection profiles.
 * 
 * This implementation takes care of updating the connection profile when
 * OK is pressed.
 * 
 * @author shongxum
 */
public abstract class ProfilePropertyPage extends PropertyPage {
	
	private boolean mAffectsConnectionProperties;

	protected ProfilePropertyPage() {
		this(false);
	}

	protected ProfilePropertyPage(boolean affectsConnectionProperties) {
		super();
		mAffectsConnectionProperties = affectsConnectionProperties;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.PreferencePage#createContents(org.eclipse.swt.widgets.Composite)
	 */
	protected Control createContents(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		final GridLayout gridLayout = new GridLayout();
		gridLayout.horizontalSpacing = 0;
		gridLayout.marginWidth = 0;
		gridLayout.marginHeight = 0;
		container.setLayout(gridLayout);

		final Composite composite = new Composite(container, SWT.NONE);
		composite.setLayout(new FillLayout());
		composite.setLayoutData(new GridData(GridData.FILL_BOTH));

		createCustomContents(composite);

		return container;
	}

	protected abstract void createCustomContents(Composite parent);

	protected abstract Properties collectProperties();

	protected IConnectionProfile getConnectionProfile() {
		IAdaptable element = getElement();
		IConnectionProfile profile = (IConnectionProfile) element
				.getAdapter(IConnectionProfile.class);
		return profile;
	}
	
	protected String getPropertiesID() {
		return getConnectionProfile().getProviderId();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.jface.preference.IPreferencePage#performOk()
	 */
	public boolean performOk() {
		IConnectionProfile profile = getConnectionProfile();
		Properties oldProps = profile.getProperties(getPropertiesID());
		Properties newProps = collectProperties();

		boolean changed = false;
		for (Iterator itr = newProps.keySet().iterator(); !changed
				&& itr.hasNext();) {
			Object key = itr.next();
			Object oldObj = oldProps.get(key);
			Object newObj = newProps.get(key);
			changed = (newObj != null && !newObj.equals(oldObj))
					|| (newObj == null && oldObj != null);
		}

		if (changed) {
			profile.setProperties(getPropertiesID(),newProps);

			if (mAffectsConnectionProperties && profile.isConnected()) {
				if (MessageDialog
						.openQuestion(
								getShell(),
								ConnectivityUIPlugin
										.getDefault()
										.getResourceString(
												"ConnectionProfileDetailsPage.AskConfirmation"), //$NON-NLS-1$
								ConnectivityUIPlugin
										.getDefault()
										.getResourceString(
												"ConnectionProfileDetailsPage.AskReconnect"))) { //$NON-NLS-1$
					profile.disconnect(null);
					profile.connect(null);
				}
			}
		}

		return super.performOk();
	}

}
