/**
 * Created on 2005-2-5
 * 
 * Copyright (c) Sybase, Inc. 2004-2006 All rights reserved.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.preferences;

import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.IHelpContextIds;
import org.eclipse.datatools.sqltools.sqleditor.internal.PreferenceConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

/**
 * @author Li Huang
 *  
 */
public class SQLFilePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage
{

    Composite _parent = null;

    /**
     *  
     */
    public SQLFilePage()
    {
        super(GRID);
        setDescription(PreferenceMessages.SQLFilePage_description); 
        setPreferenceStore(EditorCorePlugin.getDefault().getPreferenceStore());
        _parent = getFieldEditorParent();

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.preference.PreferencePage#createControl(Composite)
     */
    public void createControl(Composite parent)
    {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(getControl(), IHelpContextIds.PREFERENCES_SQL_FILES);
    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.jface.preference.FieldEditorPreferencePage#createFieldEditors()
     */
    protected void createFieldEditors()
    {
        BooleanFieldEditor booleanFieldEditor = new BooleanFieldEditor(PreferenceConstants.FAIL_TO_CONNECT_DATABASE,
            PreferenceMessages.SQLFilePage_connect_database_fail_title, SWT.SEPARATOR, getFieldEditorParent());

        addField(booleanFieldEditor);

    }

    /*
     * (non-Javadoc)
     * 
     * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
     */
    public void init(IWorkbench workbench)
    {
        // TODO Auto-generated method stub

    }
}
