/*******************************************************************************
 * Copyright (c) 2004, 2005 Sybase, Inc. and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.debugger.core;

import java.sql.Connection;

import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugTarget;
import org.eclipse.datatools.sqltools.debugger.model.SPThread;

/**
 * Database plugins should implement this interface to provide database-specific
 * features.
 * 
 * @author Hui Cao
 *  
 */

public interface SQLDebuggerConfiguration  
{

    /**
     * 
     * Returns a <code>SPThread</code> used to debug stored procedures.
     * 
     * @param target the debug target in which this thread is contained
     * @param databaseIdentifier on which database this thread is running 
     * @param connectionId the database specific connection id @see org.eclipse.datatools.sqltools.core.services.ConnectionService#getConnectionId(org.eclipse.datatools.sqltools.core.DatabaseIdentifier, java.sql.Connection)
     * @param debuggeeCon the connection to be debugged
     * @return
     */
    public SPThread getSPThread(SPDebugTarget target, DatabaseIdentifier databaseIdentifier, String id, Connection debuggeeCon);
    
    /**
     * 
     * @param profileName
     * @return
     */
    public IDebugHandler createDebugHandler(String profileName);

}
