/*******************************************************************************
 * Copyright (c) 2004, 2005 Sybase, Inc. and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Sybase, Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.sqltools.debugger.perspectives;


import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerCorePlugin;
import org.eclipse.datatools.sqltools.debugger.core.internal.DebuggerMessages;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/**
 * The Debugger persective implementation 
 *
 * @author Samir Nigam
 * @author Arathi Sarvesh - Added code for "change perspective."
 *
 */
public class DebuggerPerspective implements IPerspectiveFactory
{
	public static final String DEBUGGER_PERSPECTIVE_ID = "org.eclipse.datatools.sqltools.debugger.perspectives.DebuggerPerspective"; // "org.eclipse.debug.ui.DebugPerspective";
	
    public DebuggerPerspective()
    {
    }

    public void createInitialLayout(IPageLayout factory)
    {
        this.factory = factory;
        addViews();
        addActionSets();
    }


    private void addViews()
    {

    }

    private void addActionSets()
    {
        factory.addActionSet(IDebugUIConstants.LAUNCH_ACTION_SET);
        factory.addActionSet(IPageLayout.ID_NAVIGATE_ACTION_SET);
    }

    private IPageLayout factory;

    public static void changePerspective()
    {
        try
        {
            // Map perspective id to descriptor.
            IPerspectiveRegistry reg = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor desc = reg.findPerspectiveWithId(DEBUGGER_PERSPECTIVE_ID);
            //Get the active page.
            IWorkbench i = PlatformUI.getWorkbench();
            IWorkbenchWindow[] j = i.getWorkbenchWindows();
            IWorkbenchWindow window = i.getActiveWorkbenchWindow();

            if (window == null)
            {
            	DebuggerCorePlugin.getDefault().log(DebuggerMessages.perspective_DebuggerPerspective_activeWinNull1);
                window = j[0];
            }

            if (window == null)
            {
            	DebuggerCorePlugin.getDefault().log(DebuggerMessages.perspective_DebuggerPerspective_activeWinNull2);
            }

            IWorkbenchPage page = window.getActivePage();
            // Set the perspective.
            page.setPerspective(desc);
        }
        catch (Exception e)
        {
        	DebuggerCorePlugin.getDefault().log(DebuggerMessages.perspective_DebuggerPerspective_changePerspectiveException);
        }
    }
}
