/*
* This program and the accompanying materials 
* are made available under the terms of the Eclipse Public License v1.0
* which is available at
* http://www.eclipse.org/legal/epl-v10.html
*/

package org.eclipse.datatools.sqltools.parsers.sql.query;

public interface SQLQueryParsersym {
    public final static int
      TK_ACCESS = 95,
      TK_ACCTNG = 96,
      TK_ACTION = 97,
      TK_ACTIVATE = 98,
      TK_ADD = 99,
      TK_ADMIN = 100,
      TK_ADMINISTRATION = 101,
      TK_AFTER = 102,
      TK_AGE = 103,
      TK_ALIAS = 104,
      TK_ALL = 15,
      TK_ALLOCATE = 105,
      TK_ALLOW = 106,
      TK_ALTER = 107,
      TK_ALTERIN = 108,
      TK_ALWAYS = 109,
      TK_AND = 23,
      TK_ANY = 40,
      TK_APPEND = 110,
      TK_APPL_ID = 111,
      TK_APPL_NAME = 112,
      TK_APPLNAME = 113,
      TK_ARRAY = 41,
      TK_AS = 3,
      TK_ASC = 42,
      TK_ASCII = 114,
      TK_ASENSITIVE = 115,
      TK_ASSIGNMENT = 116,
      TK_ASSOCIATE = 117,
      TK_AST = 118,
      TK_ASUTIME = 119,
      TK_AT = 120,
      TK_ATOMIC = 121,
      TK_ATTRIBUTE = 122,
      TK_ATTRIBUTES = 123,
      TK_AUTHORIZATION = 124,
      TK_AUTH_ID = 125,
      TK_AUTHID = 126,
      TK_AUTOMATIC = 127,
      TK_AUTOSTART = 128,
      TK_AVAILABLE = 129,
      TK_B = 130,
      TK_BEFORE = 131,
      TK_BEGIN = 132,
      TK_BERNOULLI = 133,
      TK_BETWEEN = 16,
      TK_BIGINT = 134,
      TK_BINARY = 135,
      TK_BIND = 136,
      TK_BINDADD = 137,
      TK_BIT = 138,
      TK_BLOB = 139,
      TK_BLOCKED = 140,
      TK_BLOCKSIZE = 141,
      TK_BOTH = 142,
      TK_BUFFER = 143,
      TK_BUFFERPOOL = 144,
      TK_BUFFERPOOLS = 145,
      TK_BUFFERSIZE = 146,
      TK_BUILD = 147,
      TK_BY = 43,
      TK_BYPASS = 148,
      TK_C = 149,
      TK_CACHE = 150,
      TK_CACHING = 151,
      TK_CALL = 152,
      TK_CALLED = 153,
      TK_CALLER = 154,
      TK_CAPTURE = 155,
      TK_CARDINALITIES = 156,
      TK_CARDINALITY = 157,
      TK_CASCADE = 158,
      TK_CASCADED = 159,
      TK_CASE = 44,
      TK_CAST = 45,
      TK_CCSID = 160,
      TK_CHANGE = 161,
      TK_CHANGED = 162,
      TK_CHANGES = 163,
      TK_CHAR = 164,
      TK_CHARACTER = 165,
      TK_CHECK = 166,
      TK_CHECKED = 167,
      TK_CLIENT = 168,
      TK_CLIENT_ACCTNG = 169,
      TK_CLIENT_APPLNAME = 170,
      TK_CLIENT_USERID = 171,
      TK_CLIENT_WRKSTNNAME = 172,
      TK_CLOB = 173,
      TK_CLOSE = 174,
      TK_CLR = 175,
      TK_CLUSTER = 176,
      TK_COBOL = 177,
      TK_COLLECT = 178,
      TK_COLLID = 179,
      TK_COLUMN = 180,
      TK_COLUMNS = 181,
      TK_COMM = 182,
      TK_COMMENT = 183,
      TK_COMMIT = 184,
      TK_COMMITTED = 185,
      TK_COMPACT = 186,
      TK_COMPARE = 187,
      TK_COMPARISONS = 188,
      TK_COMPRESS = 189,
      TK_COMPRESSION = 190,
      TK_CONCAT = 46,
      TK_CONDITION = 191,
      TK_CONN = 192,
      TK_CONNECT = 193,
      TK_CONNECTIONS = 194,
      TK_CONNECTOPT = 195,
      TK_CONNHEADER = 196,
      TK_CONNMEMUSE = 197,
      TK_CONSERVATIVE = 198,
      TK_CONSTRAINT = 199,
      TK_CONSTRAINTS = 200,
      TK_CONSTRUCTOR = 201,
      TK_CONTAINERS = 202,
      TK_CONTAINS = 203,
      TK_CONTENT = 204,
      TK_CONTINUE = 205,
      TK_CONTINUOUSLY = 206,
      TK_CONTROL = 207,
      TK_COPY = 208,
      TK_COUNT = 209,
      TK_COUNT_BIG = 210,
      TK_CPU = 211,
      TK_CREATE = 212,
      TK_CREATE_EXTERNAL_ROUTINE = 213,
      TK_CREATEIN = 214,
      TK_CREATE_NOT_FENCED = 215,
      TK_CREATE_NOT_FENCED_ROUTINE = 216,
      TK_CREATETAB = 217,
      TK_CS = 218,
      TK_CUBE = 24,
      TK_CURRENT = 219,
      TK_CURRENT_DATE = 47,
      TK_CURRENT_DEFAULT_TRANSFORM_GROUP = 48,
      TK_CURRENT_PATH = 49,
      TK_CURRENT_ROLE = 50,
      TK_CURRENT_SCHEMA = 220,
      TK_CURRENT_SERVER = 221,
      TK_CURRENT_TIME = 51,
      TK_CURRENT_TIMESTAMP = 52,
      TK_CURRENT_TIMEZONE = 222,
      TK_CURRENT_TRANSFORM_GROUP_FOR_TYPE = 53,
      TK_CURRENT_USER = 54,
      TK_CURRVAL = 223,
      TK_CURSOR = 224,
      TK_CURSORS = 225,
      TK_CYCLE = 226,
      TK_DATA = 227,
      TK_DATABASE = 228,
      TK_DATALINK = 229,
      TK_DATE = 230,
      TK_DAY = 231,
      TK_DAYS = 55,
      TK_DB = 232,
      TK_DBADM = 233,
      TK_DBCLOB = 234,
      TK_DBINFO = 235,
      TK_DBMEMUSE = 236,
      TK_DBPARTITIONNUM = 237,
      TK_DBPARTITIONNUMS = 238,
      TK_DB2DARI = 239,
      TK_DB2GENRL = 240,
      TK_DB2GENERAL = 241,
      TK_DB2OPTIONS = 242,
      TK_DB2SPL = 243,
      TK_DB2SQL = 244,
      TK_DB2_RETURN_STATUS = 245,
      TK_DB2_TOKEN_STRING = 246,
      TK_DEACTIVATE = 247,
      TK_DEADLOCK = 248,
      TK_DEADLOCKS = 249,
      TK_DEC = 250,
      TK_DECIMAL = 251,
      TK_DECLARE = 252,
      TK_DEFAULT = 56,
      TK_DEFAULTS = 253,
      TK_DEFINE = 254,
      TK_DEFINITION = 255,
      TK_DEGREE = 256,
      TK_DEFER = 257,
      TK_DEFERRED = 258,
      TK_DELETE = 57,
      TK_DESC = 58,
      TK_DESCRIPTOR = 259,
      TK_DETAILED = 260,
      TK_DETAILS = 261,
      TK_DETERMINED = 262,
      TK_DETERMINISTIC = 263,
      TK_DEVICE = 264,
      TK_DIAGNOSTICS = 265,
      TK_DIMENSIONS = 266,
      TK_DIRTY = 267,
      TK_DISABLE = 268,
      TK_DISALLOW = 269,
      TK_DISPATCH = 270,
      TK_DISTINCT = 25,
      TK_DISTRIBUTION = 271,
      TK_DLCONN = 272,
      TK_DLLOCK = 273,
      TK_DO = 274,
      TK_DOUBLE = 275,
      TK_DROP = 276,
      TK_DROPIN = 277,
      TK_DROPPED = 278,
      TK_DYNAMIC = 279,
      TK_EACH = 280,
      TK_ELEMENT = 281,
      TK_ELSE = 59,
      TK_ELSEIF = 282,
      TK_EMPTY = 283,
      TK_ENABLE = 284,
      TK_ENCRYPTION = 285,
      TK_END = 60,
      TK_ENDING = 286,
      TK_ENFORCED = 287,
      TK_ERASE = 288,
      TK_ESCAPE = 61,
      TK_ESTIMATE = 289,
      TK_EUR = 290,
      TK_EVALUATE = 291,
      TK_EVENT = 292,
      TK_EXACT = 293,
      TK_EXCEPT = 6,
      TK_EXCEPTION = 294,
      TK_EXCLUDE = 295,
      TK_EXCLUDES = 296,
      TK_EXCLUDING = 297,
      TK_EXCLUSIVE = 298,
      TK_EXECNODE = 299,
      TK_EXECUTE = 300,
      TK_EXISTS = 301,
      TK_EXIT = 302,
      TK_EXPAND = 303,
      TK_EXPLAIN = 304,
      TK_EXPRESSION = 305,
      TK_EXTEND = 306,
      TK_EXTENDED = 307,
      TK_EXTENSION = 308,
      TK_EXTENTSIZE = 309,
      TK_EXTERNAL = 310,
      TK_FALSE = 26,
      TK_FEDERATED = 311,
      TK_FEDERATED_TOOL = 312,
      TK_FENCED = 313,
      TK_FETCH = 314,
      TK_FILE = 315,
      TK_FILTER = 316,
      TK_FINAL = 317,
      TK_FIRST = 62,
      TK_FLOAT = 318,
      TK_FLUSH = 319,
      TK_FOLLOWING = 320,
      TK_FOR = 321,
      TK_FORCE = 322,
      TK_FOREIGN = 323,
      TK__FOREIGNKEY = 324,
      TK_FOUND = 325,
      TK_FREE = 326,
      TK_FREEPAGE = 327,
      TK_FROM = 17,
      TK_FS = 328,
      TK_FULL = 7,
      TK_FUNCTION = 329,
      TK_G = 27,
      TK_GBPCACHE = 330,
      TK_GENERAL = 331,
      TK_GENERATE = 332,
      TK_GENERATED = 333,
      TK_GET = 334,
      TK_GLOBAL = 335,
      TK_GOTO = 336,
      TK_GRANT = 337,
      TK_GRAPHIC = 338,
      TK_GROUP = 28,
      TK_GROUPING = 339,
      TK_HANDLER = 340,
      TK_HASHING = 341,
      TK_HAVING = 29,
      TK_HIDDEN = 342,
      TK_HIERARCHY = 343,
      TK_HIGH = 344,
      TK_HOLD = 345,
      TK_HOUR = 346,
      TK_HOURS = 63,
      TK_HPJ = 347,
      TK_ID = 348,
      TK_IDENTITY = 349,
      TK_IF = 350,
      TK_IGNORE = 351,
      TK_IMMEDIATE = 352,
      TK_IMPLICIT_SCHEMA = 353,
      TK_IN = 4,
      TK_INCLUDE = 354,
      TK_INCLUDES = 355,
      TK_INCLUDING = 356,
      TK_INCREMENT = 357,
      TK_INCREMENTAL = 358,
      TK_INDEX = 359,
      TK_INDEXES = 360,
      TK_INDICATOR = 361,
      TK_INFIX = 362,
      TK_INFO = 363,
      TK_INHERIT = 364,
      TK_INITIALLY = 365,
      TK_INITIAL_INSTS = 366,
      TK_INITIAL_IOS = 367,
      TK_INLINE = 368,
      TK_INNER = 8,
      TK_INOUT = 369,
      TK_INPUT = 370,
      TK_INSENSITIVE = 371,
      TK_INSERT = 64,
      TK_INSTANTIABLE = 372,
      TK_INSTEAD = 373,
      TK_INSTS_PER_ARGBYTE = 374,
      TK_INSTS_PER_INVOC = 375,
      TK_INT = 376,
      TK_INTEGER = 377,
      TK_INTEGRITY = 378,
      TK_INTERSECT = 9,
      TK_INTO = 65,
      TK_IO = 379,
      TK_IOS_PER_ARGBYTE = 380,
      TK_IOS_PER_INVOC = 381,
      TK_IS = 18,
      TK_ISO = 382,
      TK_ITERATE = 383,
      TK_ISOLATION = 384,
      TK_JAVA = 385,
      TK_JIS = 386,
      TK_JOIN = 30,
      TK_K = 66,
      TK_KEEP = 387,
      TK_KEY = 388,
      TK_KEYS = 389,
      TK_L = 390,
      TK_LANGUAGE = 391,
      TK_LARGE = 67,
      TK_LAST = 68,
      TK_LATERAL = 392,
      TK_LC_CTYPE = 393,
      TK_LEADING = 394,
      TK_LEAVE = 395,
      TK_LEFT = 10,
      TK_LENGTH = 396,
      TK_LEVEL = 397,
      TK_LEVEL2 = 398,
      TK_LIBRARY = 399,
      TK_LIBRARYADM = 400,
      TK_LIKE = 19,
      TK_LIMIT = 401,
      TK_LINK = 402,
      TK_LINKTYPE = 403,
      TK_LOAD = 404,
      TK_LOCAL = 405,
      TK_LOCALE = 406,
      TK_LOCALTIME = 69,
      TK_LOCALTIMESTAMP = 70,
      TK_LOCATOR = 407,
      TK_LOCATORS = 408,
      TK_LOCK = 409,
      TK_LOCKS = 410,
      TK_LOCKSIZE = 411,
      TK_LOG = 412,
      TK_LOGGED = 413,
      TK_LONG = 414,
      TK_LONGVAR = 415,
      TK_LOOP = 416,
      TK_LOW = 417,
      TK_M = 71,
      TK_MAINTAINED = 418,
      TK_MAIN_PROG = 419,
      TK_MANAGED = 420,
      TK_MANUALSTART = 421,
      TK_MAPPING = 422,
      TK_MATCHED = 423,
      TK_MATERIALIZED = 424,
      TK_MAXFILES = 425,
      TK_MAXFILESIZE = 426,
      TK_MAXVALUE = 427,
      TK_MDC = 428,
      TK_MERGE = 429,
      TK_MESSAGE_TEXT = 430,
      TK_METHOD = 431,
      TK_METHODS = 432,
      TK_MICROSECOND = 433,
      TK_MICROSECONDS = 72,
      TK_MINPCTUSED = 434,
      TK_MINUTE = 435,
      TK_MINUTES = 73,
      TK_MINVALUE = 436,
      TK_MIXED = 437,
      TK_MODE = 438,
      TK_MODIFIES = 439,
      TK_MONITOR = 440,
      TK_MONTH = 441,
      TK_MONTHS = 74,
      TK_MOVEMENT = 442,
      TK_MULTISET = 75,
      TK_N = 76,
      TK_NAME = 443,
      TK_NEW = 444,
      TK_NEW_TABLE = 445,
      TK_NEXT = 446,
      TK_NEXTVAL = 447,
      TK_NICKNAME = 448,
      TK_NO = 449,
      TK_NOCACHE = 450,
      TK_NOCYCLE = 451,
      TK_NODE = 452,
      TK_NODES = 453,
      TK_NODEGROUP = 454,
      TK_NOMAXVALUE = 455,
      TK_NOMINVALUE = 456,
      TK_NONBLOCKED = 457,
      TK_NONE = 458,
      TK_NOORDER = 459,
      TK_NOT = 5,
      TK_NULL = 20,
      TK_NULLS = 77,
      TK_NUM = 460,
      TK_NUMBLOCKPAGES = 461,
      TK_NUMERIC = 462,
      TK_NUM_FREQVALUES = 463,
      TK_NUM_QUANTILES = 464,
      TK_OBJECT = 78,
      TK_OF = 465,
      TK_OFF = 466,
      TK_OLD = 467,
      TK_OLD_TABLE = 468,
      TK_OLE = 469,
      TK_OLEDB = 470,
      TK_ON = 31,
      TK_ONCE = 471,
      TK_ONLINE = 472,
      TK_ONLY = 473,
      TK_OPEN = 474,
      TK_OPTIMIZATION = 475,
      TK_OPTIMIZE = 476,
      TK_OPTION = 477,
      TK_OPTIONS = 478,
      TK_OR = 32,
      TK_ORDER = 33,
      TK_ORGANIZE = 479,
      TK_OUT = 480,
      TK_OUTER = 79,
      TK_OVER = 481,
      TK_OVERFLOW = 482,
      TK_OVERHEAD = 483,
      TK_OVERRIDING = 484,
      TK_P = 485,
      TK_PACKAGE = 486,
      TK_PAGE = 487,
      TK_PAGESIZE = 488,
      TK_PARALLEL = 489,
      TK_PARAMETER = 490,
      TK_PASSTHRU = 491,
      TK_PASSWORD = 492,
      TK_PATH = 493,
      TK_PARTITION = 494,
      TK_PARTITIONING = 495,
      TK_PARTITIONINGS = 496,
      TK_PATROLLER = 497,
      TK_PCTDEACTIVATE = 498,
      TK_PCTFREE = 499,
      TK_PENDING = 500,
      TK_PERCENT_ARGBYTES = 501,
      TK_PERMISSION = 502,
      TK_PIECESIZE = 503,
      TK_PIPE = 504,
      TK_PLAN = 505,
      TK_PRECEDING = 506,
      TK_PRECISION = 80,
      TK_PREDICATES = 507,
      TK_PREFETCHSIZE = 508,
      TK_PREPARE = 509,
      TK_PRESERVE = 510,
      TK_PREVIOUS = 511,
      TK_PREVVAL = 512,
      TK_PRIMARY = 513,
      TK__PRIMARYKEY = 514,
      TK_PRIQTY = 515,
      TK_PRIVILEGES = 516,
      TK_PROCEDURE = 517,
      TK_PROFILE = 518,
      TK_PROGRAM = 519,
      TK_PROPAGATE = 520,
      TK_PROTOCOL = 521,
      TK_PRUNE = 522,
      TK_PUBLIC = 523,
      TK_QUERY = 524,
      TK_QUERYNO = 525,
      TK_QUERYTAG = 526,
      TK_QUIESCE_CONNECT = 527,
      TK_RANGE = 528,
      TK_RATE = 529,
      TK_RATIO = 530,
      TK_READ = 531,
      TK_READS = 532,
      TK_REAL = 533,
      TK_RECOMMEND = 534,
      TK_RECONCILE = 535,
      TK_RECOVERY = 536,
      TK_RECREATE = 537,
      TK_REDUCE = 538,
      TK_REF = 539,
      TK_REFERENCE = 540,
      TK_REFERENCES = 541,
      TK_REFERENCING = 542,
      TK_REFRESH = 543,
      TK_REGISTERS = 544,
      TK_REGULAR = 545,
      TK_RELEASE = 546,
      TK_REMAIN = 547,
      TK_REMOTE = 548,
      TK_RENAME = 549,
      TK_REOPT = 550,
      TK_REPEATABLE = 551,
      TK_REPEAT = 552,
      TK_REPLACE = 553,
      TK_REPLICATED = 554,
      TK_REQUIRING = 555,
      TK_RESET = 556,
      TK_RESIDENT = 557,
      TK_RESIGNAL = 558,
      TK_RESIZE = 559,
      TK_RESOLVE = 560,
      TK_RESTART = 561,
      TK_RESTORE = 562,
      TK_RESTRICT = 563,
      TK_RESULT = 564,
      TK_RESULT_SET_LOCATOR = 565,
      TK_RETAIN = 566,
      TK_RETURN = 567,
      TK_RETURNS = 568,
      TK_RETURN_STATUS = 569,
      TK_REVERSE = 570,
      TK_REVOKE = 571,
      TK_RIGHT = 11,
      TK_ROLLBACK = 572,
      TK_ROLLUP = 34,
      TK_ROUTINE = 573,
      TK_ROW = 574,
      TK_ROW_COUNT = 575,
      TK_ROWS = 576,
      TK_RR = 577,
      TK_RS = 578,
      TK_RUN = 579,
      TK_S = 580,
      TK_SAMPLED = 581,
      TK_SAVEPOINT = 582,
      TK_SBCS = 583,
      TK_SCANS = 584,
      TK_SCHEMA = 585,
      TK_SCOPE = 586,
      TK_SCRATCHPAD = 587,
      TK_SCROLL = 588,
      TK_SEARCH = 589,
      TK_SECOND = 590,
      TK_SECONDS = 81,
      TK_SECQTY = 591,
      TK_SECURITYADM = 592,
      TK_SELECT = 82,
      TK_SELECTION = 593,
      TK_SELECTIVE = 594,
      TK_SELECTIVITY = 595,
      TK_SELF = 596,
      TK_SENSITIVE = 597,
      TK_SEQUENCE = 598,
      TK_SERIALIZABLE = 599,
      TK_SERVER = 600,
      TK_SESSION = 601,
      TK_SESSION_USER = 83,
      TK_SET = 35,
      TK_SETS = 84,
      TK_SETTING = 602,
      TK_SHARE = 603,
      TK_SHRLEVEL = 604,
      TK_SIGNAL = 605,
      TK_SIMPLE = 606,
      TK_SIZE = 607,
      TK_SMALLINT = 608,
      TK_SNAPSHOT = 609,
      TK_SOME = 85,
      TK_SOURCE = 610,
      TK_SPECIAL = 611,
      TK_SPECIFIC = 612,
      TK_SPECIFICATION = 613,
      TK_SPLIT = 614,
      TK_SQL = 615,
      TK_SQLDATA = 616,
      TK_SQLERROR = 617,
      TK_SQLEXCEPTION = 618,
      TK_SQLWARNING = 619,
      TK_SQLID = 620,
      TK_SQLMACRO = 621,
      TK_SQLSTATE = 622,
      TK_SSA = 623,
      TK_STABILITY = 624,
      TK_STAGING = 625,
      TK_START = 626,
      TK_STATE = 627,
      TK_STATEMENT = 628,
      TK_STATEMENTS = 629,
      TK_STATIC = 630,
      TK_STATISTICS = 631,
      TK_STARTING = 632,
      TK_STAY = 633,
      TK_STMT = 634,
      TK_STOGROUP = 635,
      TK_STORAGE = 636,
      TK_STORED = 637,
      TK_STRIP = 638,
      TK_STRIPE = 639,
      TK_STYLE = 640,
      TK_SUB = 641,
      TK_SUBSECTION = 642,
      TK_SUMMARY = 643,
      TK_SWITCH = 644,
      TK_SYMMETRIC = 645,
      TK_SYNONYM = 646,
      TK_SYSTEM = 647,
      TK_SYSTEM_USER = 86,
      TK_T = 648,
      TK_TABLE = 649,
      TK_TABLES = 650,
      TK_TABLESAMPLE = 651,
      TK_TABLESPACE = 652,
      TK_TABLESPACES = 653,
      TK_TARGET = 654,
      TK_TEMPLATE = 655,
      TK_TEMPORARY = 656,
      TK_THEN = 36,
      TK_THREADSAFE = 657,
      TK_THROUGH = 658,
      TK_TIME = 659,
      TK_TIMEOUT = 660,
      TK_TIMESTAMP = 661,
      TK_TIMEZONE = 662,
      TK_TO = 663,
      TK_TOKEN = 664,
      TK_TRAILING = 665,
      TK_TRANSACTIONS = 666,
      TK_TRANSFERRATE = 667,
      TK_TRANSFORM = 668,
      TK_TRANSFORMS = 669,
      TK_TRANSLATE = 670,
      TK_TREAT = 671,
      TK_TRIGGER = 672,
      TK_TRUE = 37,
      TK_TRUNC = 673,
      TK_TWOLEVEL = 674,
      TK_TYPE = 675,
      TK_TYPES = 676,
      TK_UNBOUNDED = 677,
      TK_UNCHECKED = 678,
      TK_UNCOMMITTED = 679,
      TK_UNDER = 680,
      TK_UNDO = 681,
      TK_UNICODE = 682,
      TK_UNION = 12,
      TK_UNIQUE = 683,
      TK_UNLINK = 684,
      TK_UNTIL = 685,
      TK_UPDATE = 87,
      TK_UR = 686,
      TK_URL = 687,
      TK_USA = 688,
      TK_USE = 689,
      TK_USAGE = 690,
      TK_USER = 88,
      TK_USERID = 691,
      TK_USING = 692,
      TK_VALUE = 89,
      TK_VALUES = 38,
      TK_VARCHAR = 693,
      TK_VARGRAPHIC = 694,
      TK_VARIANT = 695,
      TK_VARYING = 90,
      TK_VCAT = 696,
      TK_VERSION = 697,
      TK_VIEW = 698,
      TK_VOLATILE = 699,
      TK_WAIT = 700,
      TK_WHEN = 39,
      TK_WHERE = 13,
      TK_WHILE = 701,
      TK_WITH = 14,
      TK_WITHOUT = 702,
      TK_WORK = 703,
      TK_WRAPPER = 704,
      TK_WRITE = 705,
      TK_WRKSTNNAME = 706,
      TK_X = 91,
      TK_XACT = 707,
      TK_YEAR = 708,
      TK_YEARS = 92,
      TK_YES = 709,
      TK_ABSENT = 710,
      TK_ACCORDING = 711,
      TK_BASE64 = 712,
      TK_DOCUMENT = 713,
      TK_ENCODING = 714,
      TK_HEX = 715,
      TK_LOCATION = 716,
      TK_NAMESPACE = 717,
      TK_NIL = 718,
      TK_ORDINALITY = 719,
      TK_PASSING = 720,
      TK_PI = 721,
      TK_RETURNING = 722,
      TK_URI = 723,
      TK_WHITESPACE = 724,
      TK_XML = 725,
      TK_XMLAGG = 726,
      TK_XMLATTRIBUTES = 727,
      TK_XMLBINARY = 728,
      TK_XMLCAST = 729,
      TK_XMLCOMMENT = 730,
      TK_XMLCONCAT = 731,
      TK_XMLDECLARATION = 732,
      TK_XMLDOCUMENT = 733,
      TK_XMLELEMENT = 734,
      TK_XMLEXISTS = 735,
      TK_XMLFOREST = 736,
      TK_XMLNAMESPACES = 737,
      TK_XMLPARSE = 738,
      TK_XMLPI = 739,
      TK_XMLQUERY = 740,
      TK_XMLSCHEMA = 741,
      TK_XMLSERIALIZE = 742,
      TK_XMLTABLE = 743,
      TK_XMLTEXT = 744,
      TK_XMLVALIDATE = 745,
      TK_DOUBLE_QUOTE = 768,
      TK_QUOTE = 769,
      TK_LEFT_PAREN = 21,
      TK_RIGHT_PAREN = 22,
      TK_ASTERISK = 749,
      TK_PLUS_SIGN = 1,
      TK_COMMA = 746,
      TK_MINUS_SIGN = 2,
      TK_PERIOD = 760,
      TK_SOLIDUS = 761,
      TK_COLON = 770,
      TK_SEMICOLON = 771,
      TK_LESS_THAN_OPERATOR = 755,
      TK_EQUALS_OPERATOR = 754,
      TK_GREATER_THAN_OPERATOR = 756,
      TK_QUESTION_MARK = 772,
      TK_LEFT_BRACKET = 762,
      TK_RIGHT_BRACKET = 763,
      TK_VERTICAL_BAR = 773,
      TK_NOT_EQUALS_OPERATOR = 757,
      TK_GREATER_THAN_OR_EQUALS_OPERATOR = 758,
      TK_LESS_THAN_OR_EQUALS_OPERATOR = 759,
      TK_CONCAT_OPERATOR = 764,
      TK_DOUBLE_PERIOD = 774,
      TK_RIGHT_ARROW = 775,
      TK_REGULAR_IDENTIFIER = 93,
      TK_DELIMITED_IDENTIFIER = 94,
      TK_EMBEDDED_VARIABLE_NAME = 776,
      TK_UNSIGNED_INTEGER = 747,
      TK_SUFFIXED_UNSIGNED_INTEGER = 777,
      TK_EXACT_NUMERIC_LITERAL = 750,
      TK_APPROXIMATE_NUMERIC_LITERAL = 751,
      TK_NATIONAL_CHAR_STRING_LITERAL = 778,
      TK_NATIONAL_HEX_STRING_LITERAL = 779,
      TK_BIT_STRING_LITERAL = 780,
      TK_HEX_STRING_LITERAL = 781,
      TK_CHAR_STRING_LITERAL = 748,
      TK_COMMENT_STRING = 782,
      TK_DELIMITED_TYPE_IDENTIFIER = 783,
      TK_VERSION_IDENTIFIER = 784,
      TK_STATEMENT_TERMINATOR = 765,
      TK_HOSTVARIABLE = 752,
      TK_PARAMETER_MARKER = 753,
      TK_LEFT_BRACKET_TRIGRAPH = 766,
      TK_RIGHT_BRACKET_TRIGRAPH = 767,
      TK_EOLN = 785,
      TK_EOF = 786,
      TK_PARSE_ERROR = 787;

      public final static String orderedTerminalSymbols[] = {
                 "",
                 "PLUS_SIGN",
                 "MINUS_SIGN",
                 "AS",
                 "IN",
                 "NOT",
                 "EXCEPT",
                 "FULL",
                 "INNER",
                 "INTERSECT",
                 "LEFT",
                 "RIGHT",
                 "UNION",
                 "WHERE",
                 "WITH",
                 "ALL",
                 "BETWEEN",
                 "FROM",
                 "IS",
                 "LIKE",
                 "NULL",
                 "LEFT_PAREN",
                 "RIGHT_PAREN",
                 "AND",
                 "CUBE",
                 "DISTINCT",
                 "FALSE",
                 "G",
                 "GROUP",
                 "HAVING",
                 "JOIN",
                 "ON",
                 "OR",
                 "ORDER",
                 "ROLLUP",
                 "SET",
                 "THEN",
                 "TRUE",
                 "VALUES",
                 "WHEN",
                 "ANY",
                 "ARRAY",
                 "ASC",
                 "BY",
                 "CASE",
                 "CAST",
                 "CONCAT",
                 "CURRENT_DATE",
                 "CURRENT_DEFAULT_TRANSFORM_GROUP",
                 "CURRENT_PATH",
                 "CURRENT_ROLE",
                 "CURRENT_TIME",
                 "CURRENT_TIMESTAMP",
                 "CURRENT_TRANSFORM_GROUP_FOR_TYPE",
                 "CURRENT_USER",
                 "DAYS",
                 "DEFAULT",
                 "DELETE",
                 "DESC",
                 "ELSE",
                 "END",
                 "ESCAPE",
                 "FIRST",
                 "HOURS",
                 "INSERT",
                 "INTO",
                 "K",
                 "LARGE",
                 "LAST",
                 "LOCALTIME",
                 "LOCALTIMESTAMP",
                 "M",
                 "MICROSECONDS",
                 "MINUTES",
                 "MONTHS",
                 "MULTISET",
                 "N",
                 "NULLS",
                 "OBJECT",
                 "OUTER",
                 "PRECISION",
                 "SECONDS",
                 "SELECT",
                 "SESSION_USER",
                 "SETS",
                 "SOME",
                 "SYSTEM_USER",
                 "UPDATE",
                 "USER",
                 "VALUE",
                 "VARYING",
                 "X",
                 "YEARS",
                 "REGULAR_IDENTIFIER",
                 "DELIMITED_IDENTIFIER",
                 "ACCESS",
                 "ACCTNG",
                 "ACTION",
                 "ACTIVATE",
                 "ADD",
                 "ADMIN",
                 "ADMINISTRATION",
                 "AFTER",
                 "AGE",
                 "ALIAS",
                 "ALLOCATE",
                 "ALLOW",
                 "ALTER",
                 "ALTERIN",
                 "ALWAYS",
                 "APPEND",
                 "APPL_ID",
                 "APPL_NAME",
                 "APPLNAME",
                 "ASCII",
                 "ASENSITIVE",
                 "ASSIGNMENT",
                 "ASSOCIATE",
                 "AST",
                 "ASUTIME",
                 "AT",
                 "ATOMIC",
                 "ATTRIBUTE",
                 "ATTRIBUTES",
                 "AUTHORIZATION",
                 "AUTH_ID",
                 "AUTHID",
                 "AUTOMATIC",
                 "AUTOSTART",
                 "AVAILABLE",
                 "B",
                 "BEFORE",
                 "BEGIN",
                 "BERNOULLI",
                 "BIGINT",
                 "BINARY",
                 "BIND",
                 "BINDADD",
                 "BIT",
                 "BLOB",
                 "BLOCKED",
                 "BLOCKSIZE",
                 "BOTH",
                 "BUFFER",
                 "BUFFERPOOL",
                 "BUFFERPOOLS",
                 "BUFFERSIZE",
                 "BUILD",
                 "BYPASS",
                 "C",
                 "CACHE",
                 "CACHING",
                 "CALL",
                 "CALLED",
                 "CALLER",
                 "CAPTURE",
                 "CARDINALITIES",
                 "CARDINALITY",
                 "CASCADE",
                 "CASCADED",
                 "CCSID",
                 "CHANGE",
                 "CHANGED",
                 "CHANGES",
                 "CHAR",
                 "CHARACTER",
                 "CHECK",
                 "CHECKED",
                 "CLIENT",
                 "CLIENT_ACCTNG",
                 "CLIENT_APPLNAME",
                 "CLIENT_USERID",
                 "CLIENT_WRKSTNNAME",
                 "CLOB",
                 "CLOSE",
                 "CLR",
                 "CLUSTER",
                 "COBOL",
                 "COLLECT",
                 "COLLID",
                 "COLUMN",
                 "COLUMNS",
                 "COMM",
                 "COMMENT",
                 "COMMIT",
                 "COMMITTED",
                 "COMPACT",
                 "COMPARE",
                 "COMPARISONS",
                 "COMPRESS",
                 "COMPRESSION",
                 "CONDITION",
                 "CONN",
                 "CONNECT",
                 "CONNECTIONS",
                 "CONNECTOPT",
                 "CONNHEADER",
                 "CONNMEMUSE",
                 "CONSERVATIVE",
                 "CONSTRAINT",
                 "CONSTRAINTS",
                 "CONSTRUCTOR",
                 "CONTAINERS",
                 "CONTAINS",
                 "CONTENT",
                 "CONTINUE",
                 "CONTINUOUSLY",
                 "CONTROL",
                 "COPY",
                 "COUNT",
                 "COUNT_BIG",
                 "CPU",
                 "CREATE",
                 "CREATE_EXTERNAL_ROUTINE",
                 "CREATEIN",
                 "CREATE_NOT_FENCED",
                 "CREATE_NOT_FENCED_ROUTINE",
                 "CREATETAB",
                 "CS",
                 "CURRENT",
                 "CURRENT_SCHEMA",
                 "CURRENT_SERVER",
                 "CURRENT_TIMEZONE",
                 "CURRVAL",
                 "CURSOR",
                 "CURSORS",
                 "CYCLE",
                 "DATA",
                 "DATABASE",
                 "DATALINK",
                 "DATE",
                 "DAY",
                 "DB",
                 "DBADM",
                 "DBCLOB",
                 "DBINFO",
                 "DBMEMUSE",
                 "DBPARTITIONNUM",
                 "DBPARTITIONNUMS",
                 "DB2DARI",
                 "DB2GENRL",
                 "DB2GENERAL",
                 "DB2OPTIONS",
                 "DB2SPL",
                 "DB2SQL",
                 "DB2_RETURN_STATUS",
                 "DB2_TOKEN_STRING",
                 "DEACTIVATE",
                 "DEADLOCK",
                 "DEADLOCKS",
                 "DEC",
                 "DECIMAL",
                 "DECLARE",
                 "DEFAULTS",
                 "DEFINE",
                 "DEFINITION",
                 "DEGREE",
                 "DEFER",
                 "DEFERRED",
                 "DESCRIPTOR",
                 "DETAILED",
                 "DETAILS",
                 "DETERMINED",
                 "DETERMINISTIC",
                 "DEVICE",
                 "DIAGNOSTICS",
                 "DIMENSIONS",
                 "DIRTY",
                 "DISABLE",
                 "DISALLOW",
                 "DISPATCH",
                 "DISTRIBUTION",
                 "DLCONN",
                 "DLLOCK",
                 "DO",
                 "DOUBLE",
                 "DROP",
                 "DROPIN",
                 "DROPPED",
                 "DYNAMIC",
                 "EACH",
                 "ELEMENT",
                 "ELSEIF",
                 "EMPTY",
                 "ENABLE",
                 "ENCRYPTION",
                 "ENDING",
                 "ENFORCED",
                 "ERASE",
                 "ESTIMATE",
                 "EUR",
                 "EVALUATE",
                 "EVENT",
                 "EXACT",
                 "EXCEPTION",
                 "EXCLUDE",
                 "EXCLUDES",
                 "EXCLUDING",
                 "EXCLUSIVE",
                 "EXECNODE",
                 "EXECUTE",
                 "EXISTS",
                 "EXIT",
                 "EXPAND",
                 "EXPLAIN",
                 "EXPRESSION",
                 "EXTEND",
                 "EXTENDED",
                 "EXTENSION",
                 "EXTENTSIZE",
                 "EXTERNAL",
                 "FEDERATED",
                 "FEDERATED_TOOL",
                 "FENCED",
                 "FETCH",
                 "FILE",
                 "FILTER",
                 "FINAL",
                 "FLOAT",
                 "FLUSH",
                 "FOLLOWING",
                 "FOR",
                 "FORCE",
                 "FOREIGN",
                 "_FOREIGNKEY",
                 "FOUND",
                 "FREE",
                 "FREEPAGE",
                 "FS",
                 "FUNCTION",
                 "GBPCACHE",
                 "GENERAL",
                 "GENERATE",
                 "GENERATED",
                 "GET",
                 "GLOBAL",
                 "GOTO",
                 "GRANT",
                 "GRAPHIC",
                 "GROUPING",
                 "HANDLER",
                 "HASHING",
                 "HIDDEN",
                 "HIERARCHY",
                 "HIGH",
                 "HOLD",
                 "HOUR",
                 "HPJ",
                 "ID",
                 "IDENTITY",
                 "IF",
                 "IGNORE",
                 "IMMEDIATE",
                 "IMPLICIT_SCHEMA",
                 "INCLUDE",
                 "INCLUDES",
                 "INCLUDING",
                 "INCREMENT",
                 "INCREMENTAL",
                 "INDEX",
                 "INDEXES",
                 "INDICATOR",
                 "INFIX",
                 "INFO",
                 "INHERIT",
                 "INITIALLY",
                 "INITIAL_INSTS",
                 "INITIAL_IOS",
                 "INLINE",
                 "INOUT",
                 "INPUT",
                 "INSENSITIVE",
                 "INSTANTIABLE",
                 "INSTEAD",
                 "INSTS_PER_ARGBYTE",
                 "INSTS_PER_INVOC",
                 "INT",
                 "INTEGER",
                 "INTEGRITY",
                 "IO",
                 "IOS_PER_ARGBYTE",
                 "IOS_PER_INVOC",
                 "ISO",
                 "ITERATE",
                 "ISOLATION",
                 "JAVA",
                 "JIS",
                 "KEEP",
                 "KEY",
                 "KEYS",
                 "L",
                 "LANGUAGE",
                 "LATERAL",
                 "LC_CTYPE",
                 "LEADING",
                 "LEAVE",
                 "LENGTH",
                 "LEVEL",
                 "LEVEL2",
                 "LIBRARY",
                 "LIBRARYADM",
                 "LIMIT",
                 "LINK",
                 "LINKTYPE",
                 "LOAD",
                 "LOCAL",
                 "LOCALE",
                 "LOCATOR",
                 "LOCATORS",
                 "LOCK",
                 "LOCKS",
                 "LOCKSIZE",
                 "LOG",
                 "LOGGED",
                 "LONG",
                 "LONGVAR",
                 "LOOP",
                 "LOW",
                 "MAINTAINED",
                 "MAIN_PROG",
                 "MANAGED",
                 "MANUALSTART",
                 "MAPPING",
                 "MATCHED",
                 "MATERIALIZED",
                 "MAXFILES",
                 "MAXFILESIZE",
                 "MAXVALUE",
                 "MDC",
                 "MERGE",
                 "MESSAGE_TEXT",
                 "METHOD",
                 "METHODS",
                 "MICROSECOND",
                 "MINPCTUSED",
                 "MINUTE",
                 "MINVALUE",
                 "MIXED",
                 "MODE",
                 "MODIFIES",
                 "MONITOR",
                 "MONTH",
                 "MOVEMENT",
                 "NAME",
                 "NEW",
                 "NEW_TABLE",
                 "NEXT",
                 "NEXTVAL",
                 "NICKNAME",
                 "NO",
                 "NOCACHE",
                 "NOCYCLE",
                 "NODE",
                 "NODES",
                 "NODEGROUP",
                 "NOMAXVALUE",
                 "NOMINVALUE",
                 "NONBLOCKED",
                 "NONE",
                 "NOORDER",
                 "NUM",
                 "NUMBLOCKPAGES",
                 "NUMERIC",
                 "NUM_FREQVALUES",
                 "NUM_QUANTILES",
                 "OF",
                 "OFF",
                 "OLD",
                 "OLD_TABLE",
                 "OLE",
                 "OLEDB",
                 "ONCE",
                 "ONLINE",
                 "ONLY",
                 "OPEN",
                 "OPTIMIZATION",
                 "OPTIMIZE",
                 "OPTION",
                 "OPTIONS",
                 "ORGANIZE",
                 "OUT",
                 "OVER",
                 "OVERFLOW",
                 "OVERHEAD",
                 "OVERRIDING",
                 "P",
                 "PACKAGE",
                 "PAGE",
                 "PAGESIZE",
                 "PARALLEL",
                 "PARAMETER",
                 "PASSTHRU",
                 "PASSWORD",
                 "PATH",
                 "PARTITION",
                 "PARTITIONING",
                 "PARTITIONINGS",
                 "PATROLLER",
                 "PCTDEACTIVATE",
                 "PCTFREE",
                 "PENDING",
                 "PERCENT_ARGBYTES",
                 "PERMISSION",
                 "PIECESIZE",
                 "PIPE",
                 "PLAN",
                 "PRECEDING",
                 "PREDICATES",
                 "PREFETCHSIZE",
                 "PREPARE",
                 "PRESERVE",
                 "PREVIOUS",
                 "PREVVAL",
                 "PRIMARY",
                 "_PRIMARYKEY",
                 "PRIQTY",
                 "PRIVILEGES",
                 "PROCEDURE",
                 "PROFILE",
                 "PROGRAM",
                 "PROPAGATE",
                 "PROTOCOL",
                 "PRUNE",
                 "PUBLIC",
                 "QUERY",
                 "QUERYNO",
                 "QUERYTAG",
                 "QUIESCE_CONNECT",
                 "RANGE",
                 "RATE",
                 "RATIO",
                 "READ",
                 "READS",
                 "REAL",
                 "RECOMMEND",
                 "RECONCILE",
                 "RECOVERY",
                 "RECREATE",
                 "REDUCE",
                 "REF",
                 "REFERENCE",
                 "REFERENCES",
                 "REFERENCING",
                 "REFRESH",
                 "REGISTERS",
                 "REGULAR",
                 "RELEASE",
                 "REMAIN",
                 "REMOTE",
                 "RENAME",
                 "REOPT",
                 "REPEATABLE",
                 "REPEAT",
                 "REPLACE",
                 "REPLICATED",
                 "REQUIRING",
                 "RESET",
                 "RESIDENT",
                 "RESIGNAL",
                 "RESIZE",
                 "RESOLVE",
                 "RESTART",
                 "RESTORE",
                 "RESTRICT",
                 "RESULT",
                 "RESULT_SET_LOCATOR",
                 "RETAIN",
                 "RETURN",
                 "RETURNS",
                 "RETURN_STATUS",
                 "REVERSE",
                 "REVOKE",
                 "ROLLBACK",
                 "ROUTINE",
                 "ROW",
                 "ROW_COUNT",
                 "ROWS",
                 "RR",
                 "RS",
                 "RUN",
                 "S",
                 "SAMPLED",
                 "SAVEPOINT",
                 "SBCS",
                 "SCANS",
                 "SCHEMA",
                 "SCOPE",
                 "SCRATCHPAD",
                 "SCROLL",
                 "SEARCH",
                 "SECOND",
                 "SECQTY",
                 "SECURITYADM",
                 "SELECTION",
                 "SELECTIVE",
                 "SELECTIVITY",
                 "SELF",
                 "SENSITIVE",
                 "SEQUENCE",
                 "SERIALIZABLE",
                 "SERVER",
                 "SESSION",
                 "SETTING",
                 "SHARE",
                 "SHRLEVEL",
                 "SIGNAL",
                 "SIMPLE",
                 "SIZE",
                 "SMALLINT",
                 "SNAPSHOT",
                 "SOURCE",
                 "SPECIAL",
                 "SPECIFIC",
                 "SPECIFICATION",
                 "SPLIT",
                 "SQL",
                 "SQLDATA",
                 "SQLERROR",
                 "SQLEXCEPTION",
                 "SQLWARNING",
                 "SQLID",
                 "SQLMACRO",
                 "SQLSTATE",
                 "SSA",
                 "STABILITY",
                 "STAGING",
                 "START",
                 "STATE",
                 "STATEMENT",
                 "STATEMENTS",
                 "STATIC",
                 "STATISTICS",
                 "STARTING",
                 "STAY",
                 "STMT",
                 "STOGROUP",
                 "STORAGE",
                 "STORED",
                 "STRIP",
                 "STRIPE",
                 "STYLE",
                 "SUB",
                 "SUBSECTION",
                 "SUMMARY",
                 "SWITCH",
                 "SYMMETRIC",
                 "SYNONYM",
                 "SYSTEM",
                 "T",
                 "TABLE",
                 "TABLES",
                 "TABLESAMPLE",
                 "TABLESPACE",
                 "TABLESPACES",
                 "TARGET",
                 "TEMPLATE",
                 "TEMPORARY",
                 "THREADSAFE",
                 "THROUGH",
                 "TIME",
                 "TIMEOUT",
                 "TIMESTAMP",
                 "TIMEZONE",
                 "TO",
                 "TOKEN",
                 "TRAILING",
                 "TRANSACTIONS",
                 "TRANSFERRATE",
                 "TRANSFORM",
                 "TRANSFORMS",
                 "TRANSLATE",
                 "TREAT",
                 "TRIGGER",
                 "TRUNC",
                 "TWOLEVEL",
                 "TYPE",
                 "TYPES",
                 "UNBOUNDED",
                 "UNCHECKED",
                 "UNCOMMITTED",
                 "UNDER",
                 "UNDO",
                 "UNICODE",
                 "UNIQUE",
                 "UNLINK",
                 "UNTIL",
                 "UR",
                 "URL",
                 "USA",
                 "USE",
                 "USAGE",
                 "USERID",
                 "USING",
                 "VARCHAR",
                 "VARGRAPHIC",
                 "VARIANT",
                 "VCAT",
                 "VERSION",
                 "VIEW",
                 "VOLATILE",
                 "WAIT",
                 "WHILE",
                 "WITHOUT",
                 "WORK",
                 "WRAPPER",
                 "WRITE",
                 "WRKSTNNAME",
                 "XACT",
                 "YEAR",
                 "YES",
                 "ABSENT",
                 "ACCORDING",
                 "BASE64",
                 "DOCUMENT",
                 "ENCODING",
                 "HEX",
                 "LOCATION",
                 "NAMESPACE",
                 "NIL",
                 "ORDINALITY",
                 "PASSING",
                 "PI",
                 "RETURNING",
                 "URI",
                 "WHITESPACE",
                 "XML",
                 "XMLAGG",
                 "XMLATTRIBUTES",
                 "XMLBINARY",
                 "XMLCAST",
                 "XMLCOMMENT",
                 "XMLCONCAT",
                 "XMLDECLARATION",
                 "XMLDOCUMENT",
                 "XMLELEMENT",
                 "XMLEXISTS",
                 "XMLFOREST",
                 "XMLNAMESPACES",
                 "XMLPARSE",
                 "XMLPI",
                 "XMLQUERY",
                 "XMLSCHEMA",
                 "XMLSERIALIZE",
                 "XMLTABLE",
                 "XMLTEXT",
                 "XMLVALIDATE",
                 "COMMA",
                 "UNSIGNED_INTEGER",
                 "CHAR_STRING_LITERAL",
                 "ASTERISK",
                 "EXACT_NUMERIC_LITERAL",
                 "APPROXIMATE_NUMERIC_LITERAL",
                 "HOSTVARIABLE",
                 "PARAMETER_MARKER",
                 "EQUALS_OPERATOR",
                 "LESS_THAN_OPERATOR",
                 "GREATER_THAN_OPERATOR",
                 "NOT_EQUALS_OPERATOR",
                 "GREATER_THAN_OR_EQUALS_OPERATOR",
                 "LESS_THAN_OR_EQUALS_OPERATOR",
                 "PERIOD",
                 "SOLIDUS",
                 "LEFT_BRACKET",
                 "RIGHT_BRACKET",
                 "CONCAT_OPERATOR",
                 "STATEMENT_TERMINATOR",
                 "LEFT_BRACKET_TRIGRAPH",
                 "RIGHT_BRACKET_TRIGRAPH",
                 "DOUBLE_QUOTE",
                 "QUOTE",
                 "COLON",
                 "SEMICOLON",
                 "QUESTION_MARK",
                 "VERTICAL_BAR",
                 "DOUBLE_PERIOD",
                 "RIGHT_ARROW",
                 "EMBEDDED_VARIABLE_NAME",
                 "SUFFIXED_UNSIGNED_INTEGER",
                 "NATIONAL_CHAR_STRING_LITERAL",
                 "NATIONAL_HEX_STRING_LITERAL",
                 "BIT_STRING_LITERAL",
                 "HEX_STRING_LITERAL",
                 "COMMENT_STRING",
                 "DELIMITED_TYPE_IDENTIFIER",
                 "VERSION_IDENTIFIER",
                 "EOLN",
                 "EOF",
                 "PARSE_ERROR"
             };

    public final static boolean isValidForParser = true;
}
