/*******************************************************************************
 * Copyright (c) 2001, 2004 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer;

import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServerExplorerViewPart;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

/**
 * @author ljulien
 */
public class ServerExplorerNav extends CommonNavigator implements IServerExplorerViewPart
{
	public StructuredViewer getStructuredViewer() 
	{
		return this.getCommonViewer();
	}

	/**
	 * <p>
	 * Constructs and returns an instance of {@see CommonViewer}. The ID of the Eclipse view part
	 * will be used to create the viewer. The ID is important as some extensions identify themselves
	 * with a particular viewer ID.
	 * <p>
	 * 
	 * @param aParent
	 *            A composite parent to contain the Common Viewer
	 * @return An initialized instance of CommonViewer
	 */
	protected CommonViewer createCommonViewer(Composite aParent) 
	{
		return new ServerExplorerViewer (getViewSite().getId(), aParent, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
	}
}
