/*******************************************************************************
 * Copyright (c) 2001, 2006 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.actions.popup;

import java.io.IOException;
import java.util.Properties;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.IManagedConnection;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.explorer.popup.AbstractAction;
import org.eclipse.datatools.connectivity.sqm.core.internal.ui.util.CatalogUtil;
import org.eclipse.datatools.connectivity.sqm.internal.core.connection.ConnectionInfo;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.ServerToolsUIConstants;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.resources.ResourceLoader;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;

public class SaveOfflineAction extends AbstractAction
{
    private static final String SAVE_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.UPDATE_OFFLINE"); //$NON-NLS-1$
    private static final String SAVE_JOB_NAME = ResourceLoader.INSTANCE.queryString("DATATOOLS.SERVER.UI.EXPLORER.UPDATE_OFFLINE_JOB"); //$NON-NLS-1$
    private static final ISchedulingRule MUTEX = new ISchedulingRule()
    {
        public boolean isConflicting(ISchedulingRule rule)
        {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule)
        {
            return rule == this;
        }
    };

    public void selectionChanged(SelectionChangedEvent event)
    {
        super.selectionChanged(event);
        IConnectionProfile connection = (IConnectionProfile) ((IStructuredSelection) this.event.getSelection()).getFirstElement();
        final Properties prop = connection.getProperties(ServerToolsUIConstants.OFFLINE_PROPERTY_SET);
        setEnabled(connection.isConnected() && connection.getManagedConnection(
                    org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo.class.getName()) != null
                    && (prop == null || prop.isEmpty()));
    }

    public void initialize()
    {
        initializeAction(null, null, SAVE_NAME, SAVE_NAME);
    }

    public void run()
    {
        IConnectionProfile connection = (IConnectionProfile) ((IStructuredSelection) this.event.getSelection()).getFirstElement();
        if (connection.isConnected())
        {
            Job j = new UpdateJob(connection);
            j.setUser(true);
            j.schedule();
        }
    }

    private class UpdateJob extends Job
    {
        private Database database;
        private ConnectionInfo connectionInfo;

        public UpdateJob(IConnectionProfile profile)
        {
            super(SaveOfflineAction.SAVE_JOB_NAME);
            IManagedConnection connection = profile.getManagedConnection(org.eclipse.datatools.connectivity.sqm.core.connection.ConnectionInfo.class.getName());
            connectionInfo = (ConnectionInfo) connection.getConnection().getRawConnection();
            this.database = connectionInfo.getSharedDatabase();
            setRule(MUTEX);
        }

        public boolean belongsTo(Object family)
        {
            if (family == SaveOfflineAction.SAVE_JOB_NAME)
            {
                return true;
            }
            return false;
        }

        public IStatus run(IProgressMonitor monitor)
        {
            try
            {
                monitor.beginTask(SAVE_JOB_NAME + " - " + connectionInfo.getName(), 100); //$NON-NLS-1$
                monitor.worked(5);
                new CatalogUtil().load(database, monitor, 90);
                if (!monitor.isCanceled())
                {
                    monitor.subTask(""); //$NON-NLS-1$
                    connectionInfo.cacheDatabase(database);
                }
            }
            catch (IOException e)
            {
                return Status.CANCEL_STATUS;
            }
            finally
            {
                monitor.done();
            }

            if (monitor.isCanceled())
            {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

}
